/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.pde.internal.ui.editor.validation.AbstractControlValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public abstract class TextValidator
extends AbstractControlValidator {
    private ModifyListener fModifyListener;
    private boolean fAutoValidate;
    private String fCurrentText;

    public TextValidator(IManagedForm managedForm, Text control, IProject project, boolean autoValidate) {
        super(managedForm, (Control)control, project);
        this.fAutoValidate = autoValidate;
        this.intialize();
    }

    private void intialize() {
        this.fCurrentText = this.getText().getText();
        if (!this.fAutoValidate) {
            return;
        }
        this.createListeners();
        if (this.getEnabled()) {
            this.addListeners();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.getEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        if (!this.fAutoValidate) {
            return;
        }
        if (this.getEnabled()) {
            this.addListeners();
        } else {
            this.removeListeners();
        }
    }

    protected void createListeners() {
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextValidator.this.handleModifyTextEvent(e);
            }
        };
    }

    protected void handleModifyTextEvent(ModifyEvent e) {
        String newText = this.getText().getText();
        if (newText.equals(this.fCurrentText)) {
            return;
        }
        this.fCurrentText = newText;
        this.validate();
    }

    protected void addListeners() {
        this.getText().addModifyListener(this.fModifyListener);
    }

    protected void removeListeners() {
        this.getText().removeModifyListener(this.fModifyListener);
    }

    protected Text getText() {
        return (Text)this.getControl();
    }

    protected boolean autoEnable() {
        if (!this.getText().getEditable()) {
            return false;
        }
        return super.autoEnable();
    }
}

