/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.compat.parts;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.compat.internal.CopyAction;
import org.eclipse.e4.tools.compat.internal.CutAction;
import org.eclipse.e4.tools.compat.internal.PartHelper;
import org.eclipse.e4.tools.compat.internal.PasteAction;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IDirtyProviderService;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.WorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DIEditorPart<C>
extends EditorPart
implements IDirtyProviderService {
    private IEclipseContext context;
    private C component;
    private Class<C> clazz;
    private boolean dirtyState;
    private int features;
    protected static final int COPY = 1;
    protected static final int PASTE = 2;
    protected static final int CUT = 4;

    public DIEditorPart(Class<C> clazz) {
        this(clazz, 0);
    }

    public DIEditorPart(Class<C> clazz, int features) {
        this.clazz = clazz;
        this.features = features;
    }

    public void doSave(IProgressMonitor monitor) {
        IEclipseContext saveContext = this.context.createChild();
        ContextInjectionFactory.invoke(this.component, Persist.class, (IEclipseContext)saveContext);
        saveContext.dispose();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.context = PartHelper.createPartContext((WorkbenchPart)this);
        this.context.declareModifiable(IEditorInput.class);
        this.context.declareModifiable(IEditorPart.class);
        this.context.declareModifiable(IDirtyProviderService.class);
        this.context.set(IEditorPart.class, (Object)this);
        this.context.set(IDirtyProviderService.class, (Object)this);
        this.context.set(IEditorInput.class, (Object)input);
    }

    public void createPartControl(Composite parent) {
        this.component = PartHelper.createComponent(parent, this.context, this.clazz, (WorkbenchPart)this);
        this.makeActions();
    }

    protected IEclipseContext getContext() {
        return this.context;
    }

    public C getComponent() {
        return this.component;
    }

    protected void makeActions() {
        IClipboardService clipboard;
        if ((this.features & 1) == 1) {
            clipboard = (IClipboardService)this.context.get(IClipboardService.class);
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new CopyAction(clipboard));
        }
        if ((this.features & 2) == 2) {
            clipboard = (IClipboardService)this.context.get(IClipboardService.class);
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new PasteAction(clipboard));
        }
        if ((this.features & 4) == 4) {
            clipboard = (IClipboardService)this.context.get(IClipboardService.class);
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)new CutAction(clipboard));
        }
    }

    public void setDirtyState(boolean dirtyState) {
        if (dirtyState != this.dirtyState) {
            this.dirtyState = dirtyState;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.dirtyState;
    }

    public void setFocus() {
        ContextInjectionFactory.invoke(this.component, Focus.class, (IEclipseContext)this.context);
    }

    public void dispose() {
        this.context.dispose();
        this.context = null;
        super.dispose();
    }
}

