/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTableColumnsForSubclassesHandler
extends MasterDetailAction {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        this.execute((EObject)selection);
        return null;
    }

    public boolean shouldShow(EObject eObject) {
        return VTableControl.class.isInstance(eObject);
    }

    public void execute(EObject object) {
        IEMFValueProperty valueProperty;
        VTableControl tableControl = (VTableControl)VTableControl.class.cast(object);
        VDomainModelReference domainModelReference = tableControl.getDomainModelReference();
        if (domainModelReference == null || !VTableDomainModelReference.class.isInstance(domainModelReference)) {
            return;
        }
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)domainModelReference;
        EClass rootEClass = Helper.getRootEClass((EObject)tableControl);
        try {
            valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty((VDomainModelReference)tableDMR, rootEClass);
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        Object eStructuralFeature = valueProperty.getValueType();
        if (!EReference.class.isInstance(eStructuralFeature)) {
            return;
        }
        EReference eReference = (EReference)eStructuralFeature;
        LinkedHashSet<EStructuralFeature> existingFeatures = new LinkedHashSet<EStructuralFeature>();
        for (VDomainModelReference ref : tableDMR.getColumnDomainModelReferences()) {
            VFeaturePathDomainModelReference featureDMR = (VFeaturePathDomainModelReference)ref;
            existingFeatures.add(featureDMR.getDomainModelEFeature());
        }
        LinkedHashSet<VFeaturePathDomainModelReference> referencesToAdd = new LinkedHashSet<VFeaturePathDomainModelReference>();
        EClass subclass = this.getSubclass(Display.getDefault().getActiveShell(), eReference);
        if (subclass == null) {
            return;
        }
        for (EAttribute attribute : subclass.getEAllAttributes()) {
            if (existingFeatures.contains(attribute)) continue;
            VFeaturePathDomainModelReference dmr = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            dmr.setDomainModelEFeature((EStructuralFeature)attribute);
            referencesToAdd.add(dmr);
        }
        EditingDomain editingDomainFor = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        Command command = AddCommand.create((EditingDomain)editingDomainFor, (Object)tableDMR, (Object)VTablePackage.eINSTANCE.getTableDomainModelReference_ColumnDomainModelReferences(), referencesToAdd);
        editingDomainFor.getCommandStack().execute(command);
    }

    private EClass getSubclass(Shell shell, EReference reference) {
        EClass eclass = reference.getEReferenceType();
        Collection subClasses = EMFUtils.getSubClasses((EClass)eclass);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle("Select EClass");
        dialog.setMessage("Select a subclass to generate columns for all attributes from this EClass.");
        dialog.setMultipleSelection(false);
        dialog.setElements((Object[])subClasses.toArray(new EClass[subClasses.size()]));
        if (dialog.open() == 0) {
            Object firstResult = dialog.getFirstResult();
            if (firstResult != null) {
                eclass = (EClass)firstResult;
            }
        } else {
            eclass = null;
        }
        labelProvider.dispose();
        adapterFactory.dispose();
        return eclass;
    }
}

