/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.genmodel.toolbaractions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emfforms.internal.editor.genmodel.Activator;
import org.eclipse.emfforms.internal.editor.genmodel.Messages;
import org.eclipse.emfforms.internal.editor.genmodel.util.PluginXmlUtil;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.editor.IToolbarAction;
import org.eclipse.emfforms.spi.editor.helpers.ResourceUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.osgi.framework.FrameworkUtil;

public class GenerateJavaCodeAction
implements IToolbarAction {
    public Action getAction(Object currentObject, ISelectionProvider selectionProvider) {
        ResourceSet resourceSet = (ResourceSet)currentObject;
        GenModel genModel = this.getGenModel(resourceSet);
        return new CreateJavaCodeAction(genModel, selectionProvider);
    }

    protected GenModel getGenModel(ResourceSet resourceSet) {
        if (resourceSet.getResources().isEmpty()) {
            return null;
        }
        Resource topResource = (Resource)resourceSet.getResources().get(0);
        if (!topResource.getContents().isEmpty() && GenModel.class.isInstance(topResource.getContents().get(0))) {
            return (GenModel)topResource.getContents().get(0);
        }
        return null;
    }

    public boolean canExecute(Object object) {
        if (!(object instanceof ResourceSet)) {
            return false;
        }
        ResourceSet resourceSet = (ResourceSet)object;
        GenModel genModel = this.getGenModel(resourceSet);
        return genModel != null;
    }

    class CreateJavaCodeAction
    extends Action {
        private final Object[] types;
        private final ISelectionProvider selectionProvider;
        private GenModel genModel;
        private static final String FILE_NAME_PLUGIN_XML = "plugin.xml";
        private static final String FILE_NAME_META_INF = "META-INF";
        private static final String FILE_NAME_MANIFEST_MF = "MANIFEST.MF";
        private static final String REQUIRE_BUNDLE_HEADER = "Require-Bundle";
        private static final String EDITOR_BUNDLE_NAME = "org.eclipse.emfforms.editor";
        private static final String EDITOR_BUNDLE_VERSION = "1.8.0";
        private static final String EMFFORMS_EDITOR_CLASS_NAME = "org.eclipse.emfforms.spi.editor.GenericEditor";
        private static final String EMFFORMS_EDITOR_NAME = "EMFForms Editor";
        private static final String EMFFORMS_EDITOR_ID = "emfformseditor";

        CreateJavaCodeAction(String text, Object[] types, ISelectionProvider selectionProvider) {
            super(text);
            this.types = types;
            this.selectionProvider = selectionProvider;
        }

        CreateJavaCodeAction(GenModel genModel, ISelectionProvider selectionProvider) {
            this(selectionProvider);
            this.genModel = genModel;
        }

        CreateJavaCodeAction(GenModel genModel, String text, Object[] types, ISelectionProvider selectionProvider) {
            this(text, types, selectionProvider);
            this.genModel = genModel;
        }

        CreateJavaCodeAction(ISelectionProvider selectionProvider) {
            super(Messages.GenerateJavaCodeAction_generateAll, 4);
            this.selectionProvider = selectionProvider;
            this.types = new Object[]{"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject"};
            this.setMenuCreator(new GenmodelDropdownCreator());
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getResource("icons/page_white_cup.png")));
        }

        protected Action getJavaCodeAction(String text, Object[] types) {
            return new CreateJavaCodeAction(this.genModel, text, types, this.selectionProvider);
        }

        public void setGenModel(GenModel genModel) {
            this.genModel = genModel;
        }

        public void run() {
            ISelection oldSelection = this.selectionProvider.getSelection();
            this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.getGenModel()));
            this.getGenModel().reconcile();
            this.selectionProvider.setSelection(oldSelection);
            GenerateJavaCodeRunnable generateCodeRunnable = new GenerateJavaCodeRunnable(this.getGenModel());
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, (IRunnableWithProgress)generateCodeRunnable);
            }
            catch (InvocationTargetException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            }
            catch (InterruptedException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            }
        }

        public GenModel getGenModel() {
            return this.genModel;
        }

        public ISelectionProvider getSelectionProvider() {
            return this.selectionProvider;
        }

        public class GenerateJavaCodeRunnable
        implements IRunnableWithProgress {
            private final GenModel genmodel;

            GenerateJavaCodeRunnable(GenModel genmodel) {
                this.genmodel = genmodel;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.GenerateJavaCodeAction_generatingCodeTask, -1);
                this.genmodel.setCanGenerate(true);
                Generator generator = GenModelUtil.createGenerator((GenModel)this.genmodel);
                HashSet<URI> knownUris = new HashSet<URI>();
                Object[] objectArray = CreateJavaCodeAction.this.types;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object type = objectArray[n2];
                    this.generate(monitor, this.genmodel, generator, knownUris, type);
                    ++n2;
                }
            }

            private void generate(IProgressMonitor monitor, GenModel genmodel, Generator generator, Set<URI> knownUris, Object type) {
                generator.generate((Object)genmodel, type, (Monitor)new BasicMonitor.EclipseSubProgress(monitor, 1));
                HashSet<URI> uris = new HashSet<URI>(generator.getGeneratedOutputs());
                uris.removeAll(knownUris);
                knownUris.addAll(uris);
                if ("org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject".equals(type)) {
                    this.handleGeneratedEditorProject(uris, genmodel);
                }
            }

            private void handleGeneratedEditorProject(Set<URI> uris, GenModel genmodel) {
                URI pluginXml = null;
                URI manifestMf = null;
                for (URI uri : uris) {
                    if (this.isPluginXml(uri)) {
                        pluginXml = uri;
                        continue;
                    }
                    if (!this.isManifestMf(uri)) continue;
                    manifestMf = uri;
                }
                if (pluginXml != null && manifestMf != null) {
                    this.injectPluginXml(pluginXml, genmodel);
                    this.injectManifestMf(manifestMf);
                }
            }

            private boolean isPluginXml(URI uri) {
                if (uri.segmentCount() != 2) {
                    return false;
                }
                String lastSegment = uri.lastSegment();
                return CreateJavaCodeAction.FILE_NAME_PLUGIN_XML.equals(lastSegment);
            }

            private boolean isManifestMf(URI uri) {
                if (uri.segmentCount() != 3) {
                    return false;
                }
                String secondSegment = uri.segment(1);
                String lastSegment = uri.lastSegment();
                return CreateJavaCodeAction.FILE_NAME_META_INF.equals(secondSegment) && CreateJavaCodeAction.FILE_NAME_MANIFEST_MF.equals(lastSegment);
            }

            private void injectManifestMf(URI manifestMf) {
                IResource resource = ResourceUtil.getResourceFromURI((URI)manifestMf);
                IFile file = (IFile)resource;
                try {
                    InputStream original = file.getContents();
                    Manifest originalManifest = new Manifest(original);
                    Attributes attributes = originalManifest.getMainAttributes();
                    String newValue = attributes.getValue(CreateJavaCodeAction.REQUIRE_BUNDLE_HEADER);
                    newValue = newValue == null ? "" : String.valueOf(newValue) + ",";
                    newValue = String.valueOf(newValue) + CreateJavaCodeAction.EDITOR_BUNDLE_NAME;
                    if (CreateJavaCodeAction.EDITOR_BUNDLE_VERSION != null) {
                        newValue = String.valueOf(newValue) + ";bundle-version=\"1.8.0\"";
                    }
                    attributes.putValue(CreateJavaCodeAction.REQUIRE_BUNDLE_HEADER, newValue);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    originalManifest.write(bos);
                    file.setContents((InputStream)new ByteArrayInputStream(bos.toByteArray()), false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
                }
                catch (IOException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
                }
            }

            private void injectPluginXml(URI pluginXml, GenModel genmodel) {
                IResource resource = ResourceUtil.getResourceFromURI((URI)pluginXml);
                GenPackage genPackage = (GenPackage)genmodel.getGenPackages().get(0);
                PluginXmlUtil.addEditorExtensionPoint((IFile)resource, CreateJavaCodeAction.EMFFORMS_EDITOR_CLASS_NAME, false, this.getFileExtension(genmodel), MessageFormat.format("icons/full/obj16/{0}ModelFile.gif", genPackage.getPrefix()), MessageFormat.format("{0}.{1}.{2}", genmodel.getEditorPluginID(), genPackage.getPrefix(), CreateJavaCodeAction.EMFFORMS_EDITOR_ID), CreateJavaCodeAction.EMFFORMS_EDITOR_NAME);
            }

            private String getFileExtension(GenModel genmodel) {
                return ((GenPackage)genmodel.getGenPackages().get(0)).getFileExtensions();
            }
        }

        private class GenmodelDropdownCreator
        implements IMenuCreator {
            private Menu dropDown;

            private GenmodelDropdownCreator() {
            }

            public void dispose() {
                if (this.dropDown != null) {
                    this.dropDown.dispose();
                }
            }

            public Menu getMenu(Control parent) {
                this.dispose();
                this.dropDown = new Menu(parent);
                Action generateModelAndEdit = CreateJavaCodeAction.this.getJavaCodeAction(Messages.GenerateJavaCodeAction_generateModelEdit, new Object[]{"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject"});
                Action generateModel = CreateJavaCodeAction.this.getJavaCodeAction(Messages.GenerateJavaCodeAction_generateModel, new Object[]{"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject"});
                Action generateEdit = CreateJavaCodeAction.this.getJavaCodeAction(Messages.GenerateJavaCodeAction_generateEdit, new Object[]{"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject"});
                Action generateEditor = CreateJavaCodeAction.this.getJavaCodeAction(Messages.GenerateJavaCodeAction_generateEditor, new Object[]{"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject"});
                Action generateTests = CreateJavaCodeAction.this.getJavaCodeAction(Messages.GenerateJavaCodeAction_generateTests, new Object[]{"org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject"});
                new ActionContributionItem((IAction)generateModelAndEdit).fill(this.dropDown, 0);
                new ActionContributionItem((IAction)generateModel).fill(this.dropDown, 1);
                new ActionContributionItem((IAction)generateEdit).fill(this.dropDown, 2);
                new ActionContributionItem((IAction)generateEditor).fill(this.dropDown, 3);
                new ActionContributionItem((IAction)generateTests).fill(this.dropDown, 4);
                return this.dropDown;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        }
    }
}

