/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.table;

import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsTableDMRExpander")
public class EMFFormsTableDMRExpander
implements EMFFormsDMRExpander {
    private ReportService reportService;
    private EMFFormsDomainExpander domainExpander;
    private EMFFormsDatabinding emfFormsDatabinding;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsDomainExpander> eMFFormsDomainExpanderServiceReference;

    @Reference
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.eMFFormsDomainExpanderServiceReference != null) {
            bundleContext.ungetService(this.eMFFormsDomainExpanderServiceReference);
            this.domainExpander = null;
        }
    }

    private EMFFormsDomainExpander getEMFFormsDomainExpander() {
        if (this.domainExpander == null) {
            this.eMFFormsDomainExpanderServiceReference = this.bundleContext.getServiceReference(EMFFormsDomainExpander.class);
            if (this.eMFFormsDomainExpanderServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.domainExpander = (EMFFormsDomainExpander)this.bundleContext.getService(this.eMFFormsDomainExpanderServiceReference);
        }
        return this.domainExpander;
    }

    void setEMFFormsDomainExpander(EMFFormsDomainExpander domainExpander) {
        this.domainExpander = domainExpander;
    }

    @Reference
    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        IObservableList observableList;
        VDomainModelReference firstReference;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)domainModelReference).ofClass(VTableDomainModelReference.class);
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)domainModelReference;
        if (tableDMR.getDomainModelReference() == null) {
            VFeaturePathDomainModelReference featureDMR = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            featureDMR.setDomainModelEFeature(tableDMR.getDomainModelEFeature());
            featureDMR.getDomainModelEReferencePath().addAll((Collection)tableDMR.getDomainModelEReferencePath());
            firstReference = featureDMR;
        } else {
            firstReference = tableDMR.getDomainModelReference();
        }
        this.getEMFFormsDomainExpander().prepareDomainObject(firstReference, domainObject);
        try {
            observableList = this.emfFormsDatabinding.getObservableList(firstReference, domainObject);
        }
        catch (DatabindingFailedException ex) {
            throw new EMFFormsExpandingFailedException("Could not expand the given table domain model reference due to an DatabindingFailedException: " + ex.getMessage());
        }
        for (VDomainModelReference columnDMR : tableDMR.getColumnDomainModelReferences()) {
            for (Object object : observableList) {
                EObject currentTableDomainObject = (EObject)EObject.class.cast(object);
                this.getEMFFormsDomainExpander().prepareDomainObject(columnDMR, currentTableDomainObject);
            }
        }
        observableList.dispose();
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference was null."));
            return NOT_APPLICABLE;
        }
        if (VTableDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }
}

