/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.creation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="deleteOppositeReference", label="Delete Opposite Reference", description="In the metamodel, the opposite of a reference is deleted. In the model, its values are deleted, too.")
public class DeleteOppositeReference
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference whose opposite should be deleted")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="The reference needs to define an opposite")
    public boolean checkReferenceOpposite(EReference reference) {
        return reference.getEOpposite() != null;
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EReference opposite = this.reference.getEOpposite();
        EClass eClass = opposite.getEContainingClass();
        metamodel.delete((EModelElement)opposite);
        for (Instance instance : model.getAllInstances(eClass)) {
            this.deleteFeatureValue(instance, (EStructuralFeature)opposite);
        }
    }
}

