/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.simple;

import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="rename", label="Rename", description="In the metamodel, an element is renamed. In the model, nothing is changed.")
public class Rename
extends OperationImplementation {
    @EdaptParameter(main=true, description="The metamodel element to be renamed")
    public ENamedElement element;
    @EdaptParameter(description="The new name")
    public String name;

    @EdaptConstraint(description="The name must not be already defined by the children of the element's parent.")
    public boolean checkUniqueName() {
        if (this.element.eContainer() != null) {
            for (EObject sibling : this.element.eContainer().eContents()) {
                if (!(sibling instanceof ENamedElement) || !((ENamedElement)sibling).getName().equals(this.name)) continue;
                return false;
            }
        }
        return true;
    }

    public void initialize(Metamodel metamodel) {
        if (this.name == null) {
            this.name = this.element.getName();
        }
    }

    public void execute(Metamodel metamodel, Model model) {
        this.element.setName(this.name);
        if (this.element instanceof EEnumLiteral) {
            ((EEnumLiteral)this.element).setLiteral(this.name);
        }
    }
}

