/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction.ui;

import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateModelElement;
import org.eclipse.emf.compare.diff.metamodel.util.DiffSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.PropertiesTableViewer;
import org.eclipse.emf.edapt.history.reconstruction.MappingBase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

public class DiffSelectionAdapter
extends SelectionAdapter {
    private final Viewer sourceStructureViewer;
    private final PropertiesTableViewer sourcePropertiesViewer;
    private final Viewer targetStructureViewer;
    private final PropertiesTableViewer targetPropertiesViewer;
    private MappingBase mapping;

    public DiffSelectionAdapter(ModelSash sourceSash, ModelSash targetSash) {
        this((Viewer)sourceSash.getStructureViewer(), sourceSash.getPropertiesViewer(), (Viewer)targetSash.getStructureViewer(), targetSash.getPropertiesViewer());
    }

    public DiffSelectionAdapter(Viewer sourceStructureViewer, PropertiesTableViewer sourcePropertiesViewer, Viewer targetStructureViewer, PropertiesTableViewer targetPropertiesViewer) {
        this.sourceStructureViewer = sourceStructureViewer;
        this.sourcePropertiesViewer = sourcePropertiesViewer;
        this.targetStructureViewer = targetStructureViewer;
        this.targetPropertiesViewer = targetPropertiesViewer;
    }

    public void widgetSelected(SelectionEvent e) {
        Object data = ((TreeItem)e.item).getData();
        if (data instanceof EObject) {
            EObject element = (EObject)data;
            DiffSwitch<Boolean> s = new DiffSwitch<Boolean>(){

                public Boolean caseDiffGroup(DiffGroup object) {
                    EObject source = object.getRightParent();
                    DiffSelectionAdapter.this.selectSource(source);
                    if (DiffSelectionAdapter.this.mapping != null) {
                        DiffSelectionAdapter.this.selectTarget(DiffSelectionAdapter.this.mapping.getTarget(source));
                    }
                    return true;
                }

                public Boolean caseModelElementChangeLeftTarget(ModelElementChangeLeftTarget object) {
                    DiffSelectionAdapter.this.selectSource(object.getRightParent());
                    DiffSelectionAdapter.this.selectTarget(object.getLeftElement());
                    return true;
                }

                public Boolean caseModelElementChangeRightTarget(ModelElementChangeRightTarget object) {
                    DiffSelectionAdapter.this.selectSource(object.getRightElement());
                    DiffSelectionAdapter.this.selectTarget(object.getLeftParent());
                    return true;
                }

                public Boolean caseUpdateModelElement(UpdateModelElement object) {
                    DiffSelectionAdapter.this.selectSource(object.getRightElement());
                    DiffSelectionAdapter.this.selectTarget(object.getLeftElement());
                    return true;
                }

                public Boolean caseReferenceChange(ReferenceChange object) {
                    DiffSelectionAdapter.this.selectSource(object.getRightElement());
                    DiffSelectionAdapter.this.selectTarget(object.getLeftElement());
                    DiffSelectionAdapter.this.selectSourceProperty((EStructuralFeature)object.getReference());
                    DiffSelectionAdapter.this.selectTargetProperty((EStructuralFeature)object.getReference());
                    return true;
                }

                public Boolean caseAttributeChange(AttributeChange object) {
                    DiffSelectionAdapter.this.selectSource(object.getRightElement());
                    DiffSelectionAdapter.this.selectTarget(object.getLeftElement());
                    DiffSelectionAdapter.this.selectSourceProperty((EStructuralFeature)object.getAttribute());
                    DiffSelectionAdapter.this.selectTargetProperty((EStructuralFeature)object.getAttribute());
                    return true;
                }
            };
            s.doSwitch(element);
        }
    }

    public void selectSource(EObject element) {
        this.sourceStructureViewer.setSelection((ISelection)(element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element)), true);
    }

    public void selectTarget(EObject element) {
        this.targetStructureViewer.setSelection((ISelection)(element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element)), true);
    }

    private void selectSourceProperty(EStructuralFeature feature) {
        this.selectProperty((Viewer)this.sourcePropertiesViewer, feature);
    }

    private void selectTargetProperty(EStructuralFeature feature) {
        this.selectProperty((Viewer)this.targetPropertiesViewer, feature);
    }

    private void selectProperty(Viewer viewer, EStructuralFeature feature) {
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)feature), true);
        }
    }

    public void setMapping(MappingBase mapping) {
        this.mapping = mapping;
    }

    public MappingBase getMapping() {
        return this.mapping;
    }
}

