/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.selenium;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.cdi.tck.selenium.ChromeDevtoolsDriver;
import org.jboss.cdi.tck.selenium.ExtendedWebDriver;

public class DriverPool {
    ConcurrentLinkedQueue<ExtendedWebDriver> allDrivers = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<ExtendedWebDriver> availableDrivers = new ConcurrentLinkedQueue();

    public synchronized ExtendedWebDriver getOrNewInstance() {
        ExtendedWebDriver webDriver;
        ExtendedWebDriver extendedWebDriver = webDriver = this.availableDrivers.size() > 0 ? (ExtendedWebDriver)this.availableDrivers.remove() : null;
        if (webDriver == null) {
            webDriver = ChromeDevtoolsDriver.stdInit();
            this.allDrivers.add(webDriver);
        }
        webDriver.postInit();
        return webDriver;
    }

    public void returnInstance(ExtendedWebDriver driver) {
        driver.reset();
        this.availableDrivers.add(driver);
    }

    public void returnAndCloseInstance(ExtendedWebDriver driver) {
        driver.close();
        this.availableDrivers.add(driver);
    }

    public void quitInstance(ExtendedWebDriver driver) {
        driver.quit();
        this.allDrivers.remove(driver);
    }

    public void removeInstance(ExtendedWebDriver driver) {
        this.allDrivers.remove(driver);
    }

    public void quitAll() {
        this.allDrivers.stream().forEach(webDriver -> webDriver.quit());
        this.allDrivers.clear();
        this.availableDrivers.clear();
    }
}

