/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.upgrade;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.config.LoadBalancer;
import org.glassfish.loadbalancer.config.LoadBalancers;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="loadbalancerConfigUpgrade")
public class LoadBalancerConfigUpgrade
implements PostConstruct,
ConfigurationUpgrade {
    @Inject
    Domain domain;
    public static final String DEVICE_HOST_PROPERTY = "device-host";
    public static final String DEVICE_ADMIN_PORT_PROPERTY = "device-admin-port";

    public void postConstruct() {
        this.updateLoadBalancerElements();
    }

    private void updateLoadBalancerElements() {
        LoadBalancers loadBalancers = (LoadBalancers)this.domain.getExtensionByType(LoadBalancers.class);
        if (loadBalancers == null) {
            return;
        }
        List loadBalancerList = loadBalancers.getLoadBalancer();
        for (LoadBalancer loadBalancer : loadBalancerList) {
            try {
                ConfigSupport.apply((SingleConfigCode)new LoadBalancerConfigCode(), (ConfigBeanProxy)loadBalancer);
            }
            catch (TransactionFailure ex) {
                String msg = LbLogUtil.getStringManager().getString("ErrorDuringUpgrade", (Object)loadBalancer.getName(), (Object)ex.getMessage());
                Logger.getAnonymousLogger().log(Level.SEVERE, msg);
                if (!Logger.getAnonymousLogger().isLoggable(Level.FINE)) continue;
                Logger.getAnonymousLogger().log(Level.FINE, "Exception during upgrade operation", ex);
            }
        }
    }

    private static class LoadBalancerConfigCode
    implements SingleConfigCode<LoadBalancer> {
        private LoadBalancerConfigCode() {
        }

        public Object run(LoadBalancer loadBalancer) throws PropertyVetoException, TransactionFailure {
            List propertyList = loadBalancer.getProperty();
            Property deviceHostProperty = loadBalancer.getProperty(LoadBalancerConfigUpgrade.DEVICE_HOST_PROPERTY);
            if (deviceHostProperty != null) {
                propertyList.remove(deviceHostProperty);
                loadBalancer.setDeviceHost(deviceHostProperty.getValue());
            } else {
                String msg = LbLogUtil.getStringManager().getString("DeviceHostNotFound", (Object)loadBalancer.getName());
                Logger.getAnonymousLogger().log(Level.SEVERE, msg);
                loadBalancer.setDeviceHost("localhost");
            }
            Property devicePortProperty = loadBalancer.getProperty(LoadBalancerConfigUpgrade.DEVICE_ADMIN_PORT_PROPERTY);
            if (devicePortProperty != null) {
                propertyList.remove(devicePortProperty);
                loadBalancer.setDevicePort(devicePortProperty.getValue());
            } else {
                String msg = LbLogUtil.getStringManager().getString("DevicePortNotFound", (Object)loadBalancer.getName());
                Logger.getAnonymousLogger().log(Level.SEVERE, msg);
                loadBalancer.setDevicePort("443");
            }
            String autoApplyEnabled = loadBalancer.getAutoApplyEnabled();
            if (autoApplyEnabled != null) {
                loadBalancer.setAutoApplyEnabled(null);
                if (Boolean.parseBoolean(autoApplyEnabled)) {
                    String msg = LbLogUtil.getStringManager().getString("AutoApplyEnabled", (Object)loadBalancer.getName());
                    Logger.getAnonymousLogger().log(Level.WARNING, msg);
                }
            }
            return loadBalancer;
        }
    }
}

