/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TxnConverter;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

class ClusterTxnConverter
extends TxnConverter {
    ClusterTxnConverter(TransactionList transactionList, TxnLoggingStore store) {
        super(transactionList, store);
    }

    @Override
    String getPrefix() {
        return String.valueOf(Thread.currentThread()) + " ToTxnLogConverter.ClusterTxnConverter.";
    }

    void convert(TransactionInformation txnInfo) throws BrokerException {
        int state;
        if (ToTxnLogConverter.DEBUG) {
            logger.log(4, this.getPrefix() + " convertClusterToTxnLogFormat " + String.valueOf(txnInfo));
        }
        if ((state = txnInfo.getState().getState()) != 5) {
            String msg = this.getPrefix() + " convertClusterToTxnLogFormat: unknown state  " + state + " for " + String.valueOf(txnInfo);
            logger.log(32, msg);
        }
        TransactionWork txnWork = new TransactionWork();
        this.getSentMessages(txnInfo, txnWork);
        this.getConsumedMessages(txnInfo, txnWork);
        TransactionUID txid = txnInfo.getTID();
        TransactionState newState = new TransactionState(txnInfo.getState());
        TransactionBroker[] tbas = txnInfo.getClusterTransactionBrokers();
        ClusterTransaction clusterTxn = new ClusterTransaction(txid, newState, txnWork, tbas);
        this.store.logTxn(clusterTxn);
        this.deleteSentMessagesFromStore(txnWork);
    }
}

