/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class Vector
extends java.util.Vector
implements SCOCollection {
    private transient PersistenceCapable owner;
    private transient String fieldName;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient java.util.Vector added = new java.util.Vector();
    private transient java.util.Vector removed = new java.util.Vector();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", Vector.class.getClassLoader());
    private static final ResourceBundle messages1 = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", Vector.class.getClassLoader());

    public Vector(Object owner, String fieldName, Class elementType, boolean allowNulls) {
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public Vector(Object owner, String fieldName, Class elementType, boolean allowNulls, int initialCapacity) {
        super(initialCapacity);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public synchronized void setElementAt(Object obj, int index) {
        StateManager stateManager;
        this.throwUnsupportedOption();
        if (obj == null) {
            if (!this.allowNulls) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
            }
            this.removeElementAt(index);
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(obj.getClass())) {
            stateManager = this.makeDirty();
            Object o = super.elementAt(index);
            super.setElementAt(obj, index);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            if (!this.removed.remove(obj)) {
                this.added.add(obj);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{obj});
        }
        this.applyUpdates(stateManager, true);
    }

    @Override
    public synchronized void removeElementAt(int index) {
        this.throwUnsupportedOption();
        StateManager stateManager = this.makeDirty();
        Object obj = super.elementAt(index);
        super.removeElementAt(index);
        if (!this.added.remove(obj)) {
            this.removed.add(obj);
        }
        this.applyUpdates(stateManager, true);
    }

    public synchronized void insertElementAt(Object obj, int index) {
        StateManager stateManager;
        if (!this.allowNulls && obj == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(obj.getClass())) {
            stateManager = this.makeDirty();
            super.insertElementAt(obj, index);
            if (!this.removed.remove(obj)) {
                this.added.add(obj);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{obj});
        }
        this.applyUpdates(stateManager, true);
    }

    public synchronized void addElement(Object obj) {
        StateManager stateManager;
        if (!this.allowNulls && obj == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(obj.getClass())) {
            stateManager = this.makeDirty();
            super.addElement(obj);
            if (!this.removed.remove(obj)) {
                this.added.add(obj);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{obj});
        }
        this.applyUpdates(stateManager, true);
    }

    @Override
    public synchronized boolean removeElement(Object obj) {
        StateManager stateManager = this.makeDirty();
        int i = super.indexOf(obj);
        if (i > -1) {
            super.removeElementAt(i);
            if (!this.added.remove(obj)) {
                this.removed.add(obj);
            }
            this.applyUpdates(stateManager, true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeAllElements() {
        StateManager stateManager = this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (this.added.remove(o)) continue;
            this.removed.add(o);
        }
        this.added.clear();
        super.removeAllElements();
        this.applyUpdates(stateManager, true);
    }

    @Override
    public synchronized Object set(int index, Object element) {
        this.throwUnsupportedOption();
        if (element == null) {
            if (!this.allowNulls) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
            }
            return this.remove(index);
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(element.getClass())) {
            StateManager stateManager = this.makeDirty();
            Object o = super.set(index, element);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            if (!this.removed.remove(element)) {
                this.added.add(element);
            }
            this.applyUpdates(stateManager, true);
            return o;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{element});
    }

    @Override
    public synchronized boolean add(Object o) {
        if (!this.allowNulls && o == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(o.getClass())) {
            StateManager stateManager = this.makeDirty();
            if (!this.removed.remove(o)) {
                this.added.add(o);
            }
            boolean modified = super.add(o);
            this.applyUpdates(stateManager, modified);
            return modified;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{o});
    }

    @Override
    public boolean remove(Object o) {
        return this.removeElement(o);
    }

    @Override
    public void add(int index, Object element) {
        this.insertElementAt(element, index);
    }

    @Override
    public synchronized Object remove(int index) {
        this.throwUnsupportedOption();
        StateManager stateManager = this.makeDirty();
        Object obj = super.remove(index);
        if (!this.added.remove(obj)) {
            this.removed.add(obj);
        }
        this.applyUpdates(stateManager, true);
        return obj;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        if (!this.allowNulls && c.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        java.util.Vector errc = new java.util.Vector();
        if (this.elementType != null) {
            for (Object o : c) {
                if (this.elementType.isAssignableFrom(o.getClass())) continue;
                errc.add(o);
            }
        }
        if (errc != null && errc.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), errc.toArray());
        }
        StateManager stateManager = this.makeDirty();
        this.removed.removeAll(c);
        this.added.addAll(c);
        boolean modified = super.addAll(c);
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        boolean modified = false;
        StateManager stateManager = this.makeDirty();
        for (Object o : c) {
            if (!super.contains(o)) continue;
            this.removeInternal(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        if (!this.allowNulls && c.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        java.util.Vector errc = new java.util.Vector();
        if (this.elementType != null) {
            for (Object o : c) {
                if (this.elementType.isAssignableFrom(o.getClass())) continue;
                errc.add(o);
            }
        }
        if (errc != null && errc.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), errc.toArray());
        }
        StateManager stateManager = this.makeDirty();
        this.removed.removeAll(c);
        this.added.addAll(c);
        boolean modified = super.addAll(index, c);
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        boolean modified = false;
        java.util.Vector v = new java.util.Vector();
        StateManager stateManager = this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o)) continue;
            v.add(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        iter = v.iterator();
        while (iter.hasNext()) {
            this.removeInternal(iter.next());
        }
        this.applyUpdates(stateManager, modified);
        return modified;
    }

    @Override
    public Object clone() {
        Vector obj = (Vector)super.clone();
        obj.unsetOwner();
        return obj;
    }

    @Override
    public Object cloneInternal() {
        return super.clone();
    }

    @Override
    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    @Override
    public void markDeferred() {
    }

    @Override
    public boolean isDeferred() {
        return false;
    }

    @Override
    public void applyDeferredUpdates(Collection c) {
        super.addAll(c);
    }

    @Override
    public void addInternal(Object o) {
        super.addElement(o);
    }

    @Override
    public void addAllInternal(Collection c) {
        super.addAll(c);
    }

    @Override
    public void addToBaseCollection(Object o) {
        super.add(o);
    }

    @Override
    public void removeAllInternal(Collection c) {
        super.removeAll(c);
    }

    @Override
    public Collection getAdded() {
        return this.added;
    }

    @Override
    public Collection getRemoved() {
        return this.removed;
    }

    @Override
    public void clearInternal() {
        int s;
        for (int i = s = super.size() - 1; i > -1; --i) {
            super.removeElementAt(i);
        }
        this.reset();
    }

    @Override
    public void removeInternal(Object o) {
        int i = super.indexOf(o);
        super.remove(i);
    }

    @Override
    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
        this.elementType = null;
        this.added.clear();
        this.removed.clear();
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public StateManager makeDirty() {
        if (this.owner != null) {
            StateManager stateManager = this.owner.jdoGetStateManager();
            if (stateManager != null) {
                stateManager.makeDirty(this.fieldName);
            }
            return stateManager;
        }
        return null;
    }

    @Override
    public void applyUpdates(StateManager sm, boolean modified) {
        if (modified && sm != null) {
            sm.applyUpdates(this.fieldName, this);
        }
    }

    private void throwUnsupportedOption() {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "sco.not_supported"));
    }

    @Override
    public void setOwner(Object owner, String fieldName, Class elementType) {
        if (this.owner != null) {
            throw new JDOUserException(I18NHelper.getMessage(messages1, "core.statemanager.anotherowner"), new Object[]{this.owner, this.fieldName});
        }
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
            this.elementType = elementType;
        }
    }
}

