/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface ConfigValue<T> {
    public Config.Key key();

    default public String name() {
        return this.key().name();
    }

    public Optional<T> asOptional() throws ConfigMappingException;

    default public T get() throws MissingValueException, ConfigMappingException {
        return this.asOptional().orElseThrow(() -> MissingValueException.create(this.key()));
    }

    public <N> ConfigValue<N> as(Function<T, N> var1);

    public Supplier<T> supplier();

    public Supplier<T> supplier(T var1);

    public Supplier<Optional<T>> optionalSupplier();

    default public Optional<T> or(Supplier<? extends Optional<T>> supplier) {
        Objects.requireNonNull(supplier);
        Optional<T> optional = this.asOptional();
        if (optional.isEmpty()) {
            Optional<T> supplied = supplier.get();
            Objects.requireNonNull(supplied);
            optional = supplied;
        }
        return optional;
    }

    default public boolean isPresent() {
        return this.asOptional().isPresent();
    }

    default public void ifPresentOrElse(Consumer<T> action, Runnable emptyAction) {
        Optional<T> optional = this.asOptional();
        if (optional.isPresent()) {
            action.accept(optional.get());
        } else {
            emptyAction.run();
        }
    }

    default public void ifPresent(Consumer<? super T> consumer) {
        this.asOptional().ifPresent(consumer);
    }

    default public Optional<T> filter(Predicate<? super T> predicate) {
        return this.asOptional().filter(predicate);
    }

    default public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.asOptional().map(mapper);
    }

    default public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        return this.asOptional().flatMap(mapper);
    }

    default public T orElse(T other) {
        return this.asOptional().orElse(other);
    }

    default public T orElseGet(Supplier<? extends T> other) {
        return this.asOptional().orElseGet(other);
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.asOptional().orElseThrow(exceptionSupplier);
    }

    default public Stream<T> stream() {
        return this.asOptional().stream();
    }
}

