/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.internal.Util;
import org.eclipse.persistence.exceptions.ValidationException;

public class Opcodes {
    private static final String ASM_OPCCODES_ECLIPSELINK = "org.eclipse.persistence.internal.libraries.asm.Opcodes";
    private static final String ASM_OPCCODES_OW2 = "org.objectweb.asm.Opcodes";
    private static final Map<String, String> ASM_OPCCODES_MAP = new HashMap<String, String>();
    public static final int AASTORE;
    public static final int ACC_ENUM;
    public static final int ACC_FINAL;
    public static final int ACC_INTERFACE;
    public static final int ACC_PRIVATE;
    public static final int ACC_PROTECTED;
    public static final int ACC_PUBLIC;
    public static final int ACC_STATIC;
    public static final int ACC_SUPER;
    public static final int ACC_SYNTHETIC;
    public static final int ACC_TRANSIENT;
    public static final int ACONST_NULL;
    public static final int ALOAD;
    public static final int ANEWARRAY;
    public static final int ARETURN;
    public static final int ASM9;
    public static final int ASTORE;
    public static final int BIPUSH;
    public static final int CHECKCAST;
    public static final int DUP;
    public static final int F_SAME;
    public static final int GETFIELD;
    public static final int GETSTATIC;
    public static final int GOTO;
    public static final int ICONST_0;
    public static final int ICONST_1;
    public static final int ICONST_2;
    public static final int ICONST_3;
    public static final int ICONST_4;
    public static final int ICONST_5;
    public static final int IF_ACMPEQ;
    public static final int IF_ACMPNE;
    public static final int IFEQ;
    public static final int IFNE;
    public static final int IFNONNULL;
    public static final int IFNULL;
    public static final int ILOAD;
    public static final int INVOKEINTERFACE;
    public static final int INVOKESPECIAL;
    public static final int INVOKESTATIC;
    public static final int INVOKEVIRTUAL;
    public static final int IRETURN;
    public static final int NEW;
    public static final int POP;
    public static final int PUTFIELD;
    public static final int PUTSTATIC;
    public static final int RETURN;
    public static final int SIPUSH;
    public static final int V1_8;
    public static final int ACC_BRIDGE;
    public static final int ISTORE;
    public static final int DLOAD;
    public static final int LLOAD;
    public static final int ASM5;
    public static final int ASM_API_SELECTED;
    public static final int JAVA_CLASS_VERSION;

    private static int valueInt(String fieldName) {
        return (Integer)Util.getFieldValue(ASM_OPCCODES_MAP, fieldName, Integer.TYPE);
    }

    public static Class getOpcodesClass() {
        Class<?> clazz;
        String asmService = ASMFactory.getAsmService();
        try {
            String className = ASM_OPCCODES_MAP.get(asmService);
            if (className == null) {
                throw ValidationException.incorrectASMServiceProvided();
            }
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw ValidationException.notAvailableASMService();
        }
        return clazz;
    }

    static {
        ASM_OPCCODES_MAP.put("ow2", ASM_OPCCODES_OW2);
        ASM_OPCCODES_MAP.put("eclipselink", ASM_OPCCODES_ECLIPSELINK);
        AASTORE = Opcodes.valueInt("AASTORE");
        ACC_ENUM = Opcodes.valueInt("ACC_ENUM");
        ACC_FINAL = Opcodes.valueInt("ACC_FINAL");
        ACC_INTERFACE = Opcodes.valueInt("ACC_INTERFACE");
        ACC_PRIVATE = Opcodes.valueInt("ACC_PRIVATE");
        ACC_PROTECTED = Opcodes.valueInt("ACC_PROTECTED");
        ACC_PUBLIC = Opcodes.valueInt("ACC_PUBLIC");
        ACC_STATIC = Opcodes.valueInt("ACC_STATIC");
        ACC_SUPER = Opcodes.valueInt("ACC_SUPER");
        ACC_SYNTHETIC = Opcodes.valueInt("ACC_SYNTHETIC");
        ACC_TRANSIENT = Opcodes.valueInt("ACC_TRANSIENT");
        ACONST_NULL = Opcodes.valueInt("ACONST_NULL");
        ALOAD = Opcodes.valueInt("ALOAD");
        ANEWARRAY = Opcodes.valueInt("ANEWARRAY");
        ARETURN = Opcodes.valueInt("ARETURN");
        ASM9 = Opcodes.valueInt("ASM9");
        ASTORE = Opcodes.valueInt("ASTORE");
        BIPUSH = Opcodes.valueInt("BIPUSH");
        CHECKCAST = Opcodes.valueInt("CHECKCAST");
        DUP = Opcodes.valueInt("DUP");
        F_SAME = Opcodes.valueInt("F_SAME");
        GETFIELD = Opcodes.valueInt("GETFIELD");
        GETSTATIC = Opcodes.valueInt("GETSTATIC");
        GOTO = Opcodes.valueInt("GOTO");
        ICONST_0 = Opcodes.valueInt("ICONST_0");
        ICONST_1 = Opcodes.valueInt("ICONST_1");
        ICONST_2 = Opcodes.valueInt("ICONST_2");
        ICONST_3 = Opcodes.valueInt("ICONST_3");
        ICONST_4 = Opcodes.valueInt("ICONST_4");
        ICONST_5 = Opcodes.valueInt("ICONST_5");
        IF_ACMPEQ = Opcodes.valueInt("IF_ACMPEQ");
        IF_ACMPNE = Opcodes.valueInt("IF_ACMPNE");
        IFEQ = Opcodes.valueInt("IFEQ");
        IFNE = Opcodes.valueInt("IFNE");
        IFNONNULL = Opcodes.valueInt("IFNONNULL");
        IFNULL = Opcodes.valueInt("IFNULL");
        ILOAD = Opcodes.valueInt("ILOAD");
        INVOKEINTERFACE = Opcodes.valueInt("INVOKEINTERFACE");
        INVOKESPECIAL = Opcodes.valueInt("INVOKESPECIAL");
        INVOKESTATIC = Opcodes.valueInt("INVOKESTATIC");
        INVOKEVIRTUAL = Opcodes.valueInt("INVOKEVIRTUAL");
        IRETURN = Opcodes.valueInt("IRETURN");
        NEW = Opcodes.valueInt("NEW");
        POP = Opcodes.valueInt("POP");
        PUTFIELD = Opcodes.valueInt("PUTFIELD");
        PUTSTATIC = Opcodes.valueInt("PUTSTATIC");
        RETURN = Opcodes.valueInt("RETURN");
        SIPUSH = Opcodes.valueInt("SIPUSH");
        V1_8 = Opcodes.valueInt("V1_8");
        ACC_BRIDGE = Opcodes.valueInt("ACC_BRIDGE");
        ISTORE = Opcodes.valueInt("ISTORE");
        DLOAD = Opcodes.valueInt("DLOAD");
        LLOAD = Opcodes.valueInt("LLOAD");
        ASM5 = Opcodes.valueInt("ASM5");
        ASM_API_SELECTED = ASM9;
        JAVA_CLASS_VERSION = V1_8;
    }
}

