/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class ConnectionManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] destroySignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumConnections() {
        List connections = ConnectionUtil.getConnectionInfoList(null);
        return connections.size();
    }

    public void destroy(String connectionID) {
        if (connectionID == null) {
            throw new IllegalArgumentException("Null connection ID specified");
        }
        long longCxnID = 0L;
        try {
            longCxnID = Long.parseLong(connectionID);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid connection ID specified: " + connectionID);
        }
        ConnectionUtil.destroyConnection(longCxnID, "Destroy operation invoked from " + this.getMBeanDescription());
    }

    public void destroyConnectionsInService(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Null service name specified");
        }
        ConnectionUtil.destroyConnection(serviceName, "Destroy operation invoked from " + this.getMBeanDescription());
    }

    public ObjectName[] getConnections() throws MBeanException {
        List connections = ConnectionUtil.getConnectionInfoList(null);
        if (connections.size() == 0) {
            return null;
        }
        ObjectName[] oNames = new ObjectName[connections.size()];
        Iterator itr = connections.iterator();
        int i = 0;
        while (itr.hasNext()) {
            ConnectionInfo cxnInfo = (ConnectionInfo)itr.next();
            try {
                ObjectName o = MQObjectName.createConnectionConfig(Long.toString(cxnInfo.uuid));
                oNames[i++] = o;
            }
            catch (Exception e) {
                this.handleOperationException("getConnections", e);
            }
        }
        return oNames;
    }

    @Override
    public String getMBeanName() {
        return "ConnectionManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1058");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConnections", Integer.class.getName(), mbr.getString("MB1059"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("connectionID", String.class.getName(), mbr.getString("MB1065"));
        destroySignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[2];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("destroy", mbr.getString("MB1062"), destroySignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getConnections", mbr.getString("MB1063"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

