/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.enterprise.security.ee.web.integration.WebPrincipal;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.catalina.Globals;
import org.apache.catalina.LogFacade;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.security.SecurityUtil;

public class RequestFacade
implements HttpServletRequest {
    private static final SecurityPermission GET_UNWRAPPED_COYOTE_REQUEST_PERMISSION = new SecurityPermission("getUnwrappedCoyoteRequest");
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    protected Request catalinaConnectorReqest;
    private boolean maskDefaultContextMapping;
    private RequestFacadeHelper reqFacHelper;

    public RequestFacade(Request connectorRequest) {
        this(connectorRequest, false);
    }

    public RequestFacade(Request request, boolean maskDefaultContextMapping) {
        this.catalinaConnectorReqest = request;
        this.maskDefaultContextMapping = maskDefaultContextMapping;
        this.reqFacHelper = new RequestFacadeHelper(request);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.catalinaConnectorReqest = null;
        if (this.reqFacHelper != null) {
            this.reqFacHelper.clear();
        }
        this.reqFacHelper = null;
    }

    RequestFacadeHelper getRequestFacadeHelper() {
        return this.reqFacHelper;
    }

    @Override
    public Object getAttribute(String name) {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return this.catalinaConnectorReqest.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.catalinaConnectorReqest.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.checkRequestNull();
        this.catalinaConnectorReqest.setCharacterEncoding(env);
    }

    @Override
    public int getContentLength() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getInputStream();
    }

    @Override
    public HttpServletMapping getHttpServletMapping() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getHttpServletMapping();
    }

    @Override
    public String getParameter(String name) {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.catalinaConnectorReqest.getParameter(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetParameterNamesPrivilegedAction());
        }
        return this.catalinaConnectorReqest.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        this.checkRequestNull();
        String[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.catalinaConnectorReqest.getParameterValues(name);
        }
        return ret;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.catalinaConnectorReqest.getParameterMap();
    }

    @Override
    public String getProtocol() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getProtocol();
    }

    @Override
    public String getScheme() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getScheme();
    }

    @Override
    public String getServerName() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getServerName();
    }

    @Override
    public int getServerPort() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getReader();
    }

    @Override
    public String getRemoteAddr() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.checkRequestNull();
        this.catalinaConnectorReqest.setAttribute(name, o);
    }

    @Override
    public void removeAttribute(String name) {
        this.checkRequestNull();
        this.catalinaConnectorReqest.removeAttribute(name);
    }

    @Override
    public Locale getLocale() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.catalinaConnectorReqest.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return this.catalinaConnectorReqest.getLocales();
    }

    @Override
    public boolean isSecure() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path));
        }
        return this.catalinaConnectorReqest.getRequestDispatcher(path);
    }

    @Override
    public String getAuthType() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getAuthType();
    }

    @Override
    public Cookie[] getCookies() {
        this.checkRequestNull();
        Cookie[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (Cookie[])ret.clone();
            }
        } else {
            ret = this.catalinaConnectorReqest.getCookies();
        }
        return ret;
    }

    @Override
    public long getDateHeader(String name) {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return this.catalinaConnectorReqest.getHeaders(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return this.catalinaConnectorReqest.getHeaderNames();
    }

    @Override
    public int getIntHeader(String name) {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getIntHeader(name);
    }

    @Override
    public Map<String, String> getTrailerFields() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getTrailerFields();
    }

    @Override
    public boolean isTrailerFieldsReady() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isTrailerFieldsReady();
    }

    @Override
    public String getMethod() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getMethod();
    }

    @Override
    public String getPathInfo() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getPathTranslated();
    }

    @Override
    public ServletContext getServletContext() {
        return this.catalinaConnectorReqest.getServletContext();
    }

    @Override
    public String getContextPath() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getContextPath(this.maskDefaultContextMapping);
    }

    public String getContextPath(boolean maskDefaultContextMapping) {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getContextPath(maskDefaultContextMapping);
    }

    @Override
    public String getQueryString() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isUserInRole(role);
    }

    @Override
    public Principal getUserPrincipal() {
        WebPrincipal webPrincipal;
        this.checkRequestNull();
        Principal principal = this.catalinaConnectorReqest.getUserPrincipal();
        if (principal instanceof WebPrincipal && (webPrincipal = (WebPrincipal)principal).getCustomPrincipal() != null) {
            principal = webPrincipal.getCustomPrincipal();
        }
        return principal;
    }

    public Principal getRequestPrincipal() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRequestURI(this.maskDefaultContextMapping);
    }

    @Override
    public StringBuffer getRequestURL() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRequestURL(this.maskDefaultContextMapping);
    }

    @Override
    public String getServletPath() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getServletPath();
    }

    @Override
    public HttpSession getSession(boolean create) {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetSessionPrivilegedAction(create));
        }
        return this.catalinaConnectorReqest.getSession(create);
    }

    @Override
    public HttpSession getSession() {
        this.checkRequestNull();
        return this.getSession(true);
    }

    @Override
    public String changeSessionId() {
        this.checkRequestNull();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new ChangeSessionIdPrivilegedAction());
        }
        return this.catalinaConnectorReqest.changeSessionId();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isRequestedSessionIdFromURL();
    }

    @Override
    public String getLocalAddr() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getLocalAddr();
    }

    @Override
    public String getLocalName() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getLocalName();
    }

    @Override
    public int getLocalPort() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getLocalPort();
    }

    @Override
    public int getRemotePort() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRemotePort();
    }

    @Override
    public DispatcherType getDispatcherType() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getDispatcherType();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.startAsync();
    }

    @Override
    public AsyncContext startAsync(ServletRequest sreq, ServletResponse sresp) throws IllegalStateException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.startAsync(sreq, sresp);
    }

    @Override
    public boolean isAsyncStarted() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isAsyncStarted();
    }

    @Override
    public boolean isAsyncSupported() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.isAsyncSupported();
    }

    @Override
    public AsyncContext getAsyncContext() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getAsyncContext();
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getParts();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getPart(name);
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.authenticate(response);
    }

    @Override
    public void login(String username, String password) throws ServletException {
        this.checkRequestNull();
        this.catalinaConnectorReqest.login(username, password);
    }

    @Override
    public void logout() throws ServletException {
        this.checkRequestNull();
        this.catalinaConnectorReqest.logout();
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.upgrade(handlerClass);
    }

    @Override
    public PushBuilder newPushBuilder() {
        return this.catalinaConnectorReqest.newPushBuilder();
    }

    public Request getUnwrappedCoyoteRequest() throws AccessControlException {
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.checkPermission(GET_UNWRAPPED_COYOTE_REQUEST_PERMISSION);
        }
        return this.catalinaConnectorReqest;
    }

    @Override
    public String getRequestId() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getRequestId();
    }

    @Override
    public String getProtocolRequestId() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getProtocolRequestId();
    }

    @Override
    public ServletConnection getServletConnection() {
        this.checkRequestNull();
        return this.catalinaConnectorReqest.getServletConnection();
    }

    private void checkRequestNull() {
        if (this.catalinaConnectorReqest == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00074"));
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetAttributePrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.catalinaConnectorReqest.getAttributeNames();
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction<String> {
        private GetCharacterEncodingPrivilegedAction() {
        }

        @Override
        public String run() {
            return RequestFacade.this.catalinaConnectorReqest.getCharacterEncoding();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction<String> {
        public String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String run() {
            return RequestFacade.this.catalinaConnectorReqest.getParameter(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetParameterNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.catalinaConnectorReqest.getParameterNames();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction<String[]> {
        public String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String[] run() {
            return RequestFacade.this.catalinaConnectorReqest.getParameterValues(this.name);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction<Map<String, String[]>> {
        private GetParameterMapPrivilegedAction() {
        }

        @Override
        public Map<String, String[]> run() {
            return RequestFacade.this.catalinaConnectorReqest.getParameterMap();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction<Locale> {
        private GetLocalePrivilegedAction() {
        }

        @Override
        public Locale run() {
            return RequestFacade.this.catalinaConnectorReqest.getLocale();
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction<Enumeration<Locale>> {
        private GetLocalesPrivilegedAction() {
        }

        @Override
        public Enumeration<Locale> run() {
            return RequestFacade.this.catalinaConnectorReqest.getLocales();
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction<RequestDispatcher> {
        private String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        @Override
        public RequestDispatcher run() {
            return RequestFacade.this.catalinaConnectorReqest.getRequestDispatcher(this.path);
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction<Cookie[]> {
        private GetCookiesPrivilegedAction() {
        }

        @Override
        public Cookie[] run() {
            return RequestFacade.this.catalinaConnectorReqest.getCookies();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.catalinaConnectorReqest.getHeaders(this.name);
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetHeaderNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.catalinaConnectorReqest.getHeaderNames();
        }
    }

    private final class GetSessionPrivilegedAction
    implements PrivilegedAction<HttpSession> {
        private boolean create;

        public GetSessionPrivilegedAction(boolean create) {
            this.create = create;
        }

        @Override
        public HttpSession run() {
            return RequestFacade.this.catalinaConnectorReqest.getSession(this.create);
        }
    }

    private final class ChangeSessionIdPrivilegedAction
    implements PrivilegedAction<String> {
        private ChangeSessionIdPrivilegedAction() {
        }

        @Override
        public String run() {
            return RequestFacade.this.catalinaConnectorReqest.changeSessionId();
        }
    }
}

