/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.SharedConnectionImpl;
import com.sun.messaging.bridge.service.jms.SharedXAConnectionImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedConnectionFactory
implements Runnable {
    private Logger _logger = null;
    private Object cF = null;
    private int idleTimeout = 0;
    private int maxRetries = 0;
    private int retryInterval = 0;
    private ScheduledExecutorService _scheduler = null;
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _refcnt0 = this._lock.newCondition();
    private SharedConnection _conn = null;
    private int refCount = 0;
    private ScheduledFuture _future = null;
    private boolean _closed = false;
    private String _username = null;
    private String _password = null;
    private EventNotifier _notifier = new EventNotifier();
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public SharedConnectionFactory(Object cf, Properties attrs, Logger logger) {
        this.cF = cf;
        this._logger = logger;
        String val = attrs.getProperty("username");
        if (val != null) {
            this._username = val.trim();
            this._password = attrs.getProperty("password");
        }
        this.idleTimeout = Integer.parseInt(attrs.getProperty("idle-timeout-in-seconds", "1800"));
        if (this.idleTimeout < 0) {
            this.idleTimeout = 0;
        }
        this.maxRetries = Integer.parseInt(attrs.getProperty("connect-attempts", "-1"));
        this.retryInterval = Integer.parseInt(attrs.getProperty("connect-attempt-interval-in-seconds", "5"));
        if (this.retryInterval < 0) {
            this.retryInterval = 0;
        }
        this._scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Connection c, String logstr, Object caller, boolean doReconnect) throws Exception {
        this._lock.lockInterruptibly();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Obtaining shared connection from shared connection factory " + String.valueOf(this));
        }
        if (this._closed) {
            if (c == null) {
                throw new JMSException(_jbr.getString("BSJ4028", this.toString()));
            }
            try {
                c.close();
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to close conneciton from shared connection factory " + String.valueOf(this));
            }
            throw new JMSException(_jbr.getString("BSJ4028", this.toString()));
        }
        if (c != null) {
            this._conn = c instanceof XAConnection ? new SharedXAConnectionImpl((XAConnection)c) : new SharedConnectionImpl(c);
        }
        if (this._conn != null && !this._conn.isValid()) {
            try {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1048", c.toString(), this.toString()));
                ((Connection)((Object)this._conn)).close();
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to close invalid connection " + String.valueOf(this._conn) + " from shared connection factory " + String.valueOf(this));
            }
            this._conn = null;
        }
        try {
            if (this._conn == null) {
                Connection cn = null;
                EventListener l = new EventListener(this);
                try {
                    this._notifier.addEventListener(EventListener.EventType.CONN_CLOSE, l);
                    cn = JMSBridge.openConnection(this.cF, this.maxRetries, this.retryInterval, this._username, this._password, logstr, caller, l, this._logger, doReconnect);
                }
                finally {
                    this._notifier.removeEventListener(l);
                }
                this._conn = this.cF instanceof XAConnectionFactory ? new SharedXAConnectionImpl((XAConnection)cn) : new SharedConnectionImpl(cn);
            }
            if (this._closed) {
                try {
                    ((Connection)((Object)this._conn)).close();
                }
                catch (Exception e) {
                    this._logger.log(Level.FINE, "Exception on closing connection " + String.valueOf(this._conn) + ": " + e.getMessage());
                }
                this._conn = null;
                throw new JMSException(_jbr.getString("BSJ4028", this.toString()));
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Increment refcnt in shared connection factory " + String.valueOf(this));
            }
            ++this.refCount;
            if (this._future != null) {
                this._future.cancel(true);
                this._future = null;
            }
        }
        finally {
            this._lock.unlock();
        }
        return (Connection)((Object)this._conn);
    }

    public void returnConnection(Connection conn) throws Exception {
        this._lock.lock();
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Decrement refcnt in shared connection factory " + String.valueOf(this));
            }
            --this.refCount;
            assert (this.refCount >= 0);
            if (this.refCount == 0 && this.idleTimeout > 0) {
                if (this._future != null) {
                    this._future.cancel(true);
                }
                this._logger.log(Level.INFO, _jbr.getString("BSJ1049", this.idleTimeout, this.toString()));
                this._future = this._scheduler.schedule(this, (long)this.idleTimeout, TimeUnit.SECONDS);
            }
            if (this.refCount == 0) {
                this._refcnt0.signalAll();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void run() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Check idle timeout in shared connection factory " + String.valueOf(this));
        }
        try {
            this._lock.lockInterruptibly();
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, "Unable to get lock for idle connection check in shared connection factory " + String.valueOf(this) + ": " + t.getMessage());
            return;
        }
        try {
            if (this.refCount > 0) {
                return;
            }
            this._logger.log(Level.INFO, _jbr.getString("BSJ1050", this._conn.toString(), this.toString()));
            try {
                ((Connection)((Object)this._conn)).close();
                this._conn = null;
            }
            catch (Throwable t) {
                try {
                    this._logger.log(Level.WARNING, "Exception in closing idle timed out shared connection: " + t.getMessage() + " in shared connection factory " + String.valueOf(this));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this._conn = null;
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this._closed = true;
        this._logger.log(Level.INFO, _jbr.getString("BSJ1051", this.toString()));
        this._notifier.notifyEvent(EventListener.EventType.CONN_CLOSE, this);
        this._scheduler.shutdownNow();
        boolean done = false;
        try {
            this._lock.lockInterruptibly();
            try {
                if (this._conn == null) {
                    return;
                }
                if (this.refCount > 0) {
                    this._logger.log(Level.WARNING, "Force close shared connection factory " + String.valueOf(this) + " with outstanding reference count " + this.refCount);
                }
                ((Connection)((Object)this._conn)).close();
                done = true;
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in closing shared connection " + e.getMessage());
            }
            finally {
                this._lock.unlock();
            }
        }
        finally {
            Connection c = (Connection)((Object)this._conn);
            try {
                if (c != null && !done) {
                    c.close();
                }
            }
            catch (Exception e) {
                this._logger.log(Level.FINE, "Exception in closing shared connection " + String.valueOf(c) + ": " + e.getMessage());
            }
        }
    }

    public String toString() {
        return String.valueOf(this.cF) + "[" + this.refCount + "]";
    }

    public Object getCF() {
        return this.cF;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getRefCount() {
        return this.refCount;
    }
}

