/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.spi.RuntimeBuilder;

public abstract class GlassFishRuntime {
    private static final Logger logger = Logger.getLogger(GlassFishRuntime.class.getPackage().getName());
    private static GlassFishRuntime me;

    protected GlassFishRuntime() {
    }

    public static GlassFishRuntime bootstrap() throws GlassFishException {
        return GlassFishRuntime.bootstrap(new BootstrapProperties(), GlassFishRuntime.class.getClassLoader());
    }

    public static GlassFishRuntime bootstrap(BootstrapProperties bootstrapProperties) throws GlassFishException {
        return GlassFishRuntime.bootstrap(bootstrapProperties, GlassFishRuntime.class.getClassLoader());
    }

    public static GlassFishRuntime bootstrap(BootstrapProperties bootstrapProperties, ClassLoader cl) throws GlassFishException {
        return GlassFishRuntime._bootstrap(bootstrapProperties, cl);
    }

    public abstract void shutdown() throws GlassFishException;

    public GlassFish newGlassFish() throws GlassFishException {
        return this.newGlassFish(new GlassFishProperties());
    }

    public abstract GlassFish newGlassFish(GlassFishProperties var1) throws GlassFishException;

    private static synchronized GlassFishRuntime _bootstrap(BootstrapProperties bootstrapProperties, ClassLoader cl) throws GlassFishException {
        if (me != null) {
            throw new GlassFishException("Already bootstrapped", null);
        }
        ClassLoader classLoader = cl == null ? GlassFishRuntime.class.getClassLoader() : cl;
        RuntimeBuilder runtimeBuilder = GlassFishRuntime.getRuntimeBuilder(bootstrapProperties, classLoader);
        me = runtimeBuilder.build(bootstrapProperties);
        return me;
    }

    protected static synchronized void shutdownInternal() throws GlassFishException {
        if (me == null) {
            throw new GlassFishException("Already shutdown", null);
        }
        me = null;
        System.out.println("Completed shutdown of GlassFish runtime");
    }

    private static RuntimeBuilder getRuntimeBuilder(BootstrapProperties bootstrapProperties, ClassLoader classLoader) throws GlassFishException {
        logger.logp(Level.FINE, "GlassFishRuntime", "getRuntimeBuilder", "classloader={0}", classLoader);
        Iterator<RuntimeBuilder> runtimeBuilders = ServiceLoader.load(RuntimeBuilder.class, classLoader).iterator();
        while (runtimeBuilders.hasNext()) {
            try {
                RuntimeBuilder builder = runtimeBuilders.next();
                logger.logp(Level.FINE, "GlassFishRuntime", "getRuntimeBuilder", "builder = {0}", builder);
                if (!builder.handles(bootstrapProperties)) continue;
                return builder;
            }
            catch (ServiceConfigurationError sce) {
                logger.logp(Level.FINE, "GlassFishRuntime", "getRuntimeBuilder", "Ignoring", sce);
            }
            catch (NoClassDefFoundError ncdfe) {
                logger.logp(Level.FINE, "GlassFishRuntime", "getRuntimeBuilder", "Ignoring", ncdfe);
            }
        }
        throw new GlassFishException("No runtime builder available for this configuration: " + String.valueOf(bootstrapProperties.getProperties()), null);
    }
}

