/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-jms-resource")
@PerLookup
@I18n(value="delete.jms.resource")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.DELETE, path="delete-jms-resource", description="delete-jms-resource")})
public class DeleteJMSResource
implements AdminCommand {
    private static final System.Logger LOG = System.getLogger(DeleteJMSResource.class.getName());
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(DeleteJMSResource.class);
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Param(optional=true, defaultValue="false")
    private Boolean cascade;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator habitat;
    private static final String JNDINAME_APPENDER = "-Connection-Pool";
    private String jndiNameForConnectionPool;

    public void execute(AdminCommandContext context) {
        LOG.log(System.Logger.Level.DEBUG, "execute(context={0}); jndiName={1}, target={2}", context, this.jndiName, this.target);
        ActionReport report = context.getActionReport();
        if (this.jndiName == null) {
            report.setMessage(I18N.getLocalString("delete.jms.resource.noJndiName", "No JNDI name defined for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.jndiNameForConnectionPool = this.jndiName + JNDINAME_APPENDER;
        ActionReport subReport = report.addSubActionsReport();
        ConnectorResource cresource = null;
        Resource res = this.domain.getResources().getResourceByName(ConnectorResource.class, SimpleJndiName.of((String)this.jndiName));
        if (res instanceof ConnectorResource) {
            cresource = (ConnectorResource)res;
        }
        if (cresource == null) {
            ParameterMap params = new ParameterMap();
            params.set((Object)"jndi_name", (Object)this.jndiName);
            params.set((Object)"DEFAULT", (Object)this.jndiName);
            params.set((Object)"target", (Object)this.target);
            this.commandRunner.getCommandInvocation("delete-admin-object", subReport, context.getSubject()).parameters(params).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(I18N.getLocalString("delete.jms.resource.cannotDeleteJMSAdminObject", "Unable to Delete Admin Object."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            ParameterMap params;
            if (!this.cascade.booleanValue()) {
                ConnectorResource resource;
                Collection connectorResources = this.domain.getResources().getResources(ConnectorResource.class);
                String connPoolName = this.jndiName + JNDINAME_APPENDER;
                int count = 0;
                Iterator iterator = connectorResources.iterator();
                while (iterator.hasNext() && (!connPoolName.equals((resource = (ConnectorResource)iterator.next()).getPoolName()) || ++count <= 1)) {
                }
                if (count > 1) {
                    report.setMessage(I18N.getLocalString("found.more.connector.resources", "Some connector resources are referencing connection pool {0}. Use 'cascade' option to delete them", new Object[]{connPoolName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ActionReport listReport = (ActionReport)this.habitat.getService(ActionReport.class, new Annotation[0]);
            ParameterMap listParams = new ParameterMap();
            listParams.set((Object)"target", (Object)this.target);
            this.commandRunner.getCommandInvocation("list-jms-resources", listReport, context.getSubject()).parameters(listParams).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)listReport.getActionExitCode())) {
                report.setMessage(I18N.getLocalString("list.jms.resources.fail", "Unable to list JMS Resources"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Properties extraProps = listReport.getExtraProperties();
            if (extraProps != null && extraProps.size() > 0) {
                boolean resourceExist = false;
                for (int i = 0; i < extraProps.size(); ++i) {
                    List nameList = (List)extraProps.get("jmsResources");
                    for (Map m : nameList) {
                        String jndi = (String)m.get("name");
                        if (!this.jndiName.equals(jndi)) continue;
                        resourceExist = true;
                        break;
                    }
                    if (resourceExist) break;
                }
                if (!resourceExist) {
                    report.setMessage(I18N.getLocalString("jms.resources.not.found", "JMS Resource {0} not found", new Object[]{this.jndiName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            String defPoolName = this.jndiNameForConnectionPool;
            String poolName = cresource.getPoolName();
            if (poolName != null && poolName.equals(defPoolName)) {
                params = new ParameterMap();
                params.set((Object)"DEFAULT", (Object)this.jndiName);
                params.set((Object)"connector_resource_name", (Object)this.jndiName);
                params.set((Object)"target", (Object)this.target);
                this.commandRunner.getCommandInvocation("delete-connector-resource", subReport, context.getSubject()).parameters(params).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(I18N.getLocalString("delete.jms.resource.cannotDeleteJMSResource", "Unable to Delete Connector Resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                params = new ParameterMap();
                params.set((Object)"poolname", (Object)this.jndiName);
                params.set((Object)"cascade", (Object)this.cascade.toString());
                params.set((Object)"DEFAULT", (Object)this.jndiNameForConnectionPool);
                this.commandRunner.getCommandInvocation("delete-connector-connection-pool", subReport, context.getSubject()).parameters(params).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(I18N.getLocalString("delete.jms.resource.cannotDeleteJMSPool", "Unable to Delete Connector Connection Pool."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                subReport.setMessage("");
            } else {
                params = new ParameterMap();
                params.set((Object)"DEFAULT", (Object)this.jndiName);
                params.set((Object)"connector_resource_name", (Object)this.jndiName);
                params.set((Object)"target", (Object)this.target);
                this.commandRunner.getCommandInvocation("delete-connector-resource", subReport, context.getSubject()).parameters(params).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(I18N.getLocalString("delete.jms.resource.cannotDeleteJMSResource", "Unable to Delete Connector Resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

