/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.INSTANCE})
@Service(name="_get-log-file")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.log.file")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_get-log-file", description="_get-log-file")})
public class InstanceGetLogFileCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InstanceGetLogFileCommand.class);
    @Inject
    private ServerEnvironment env;
    @Inject
    GFFileHandler gf;

    public void execute(AdminCommandContext context) {
        try {
            File logFile = this.gf.getCurrentLogFile();
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            Properties props = new Properties();
            props.setProperty("file-xfer-root", ".");
            outboundPayload.attachFile("application/octet-stream", URI.create(logFile.getName()), "files", props, logFile);
        }
        catch (Exception e) {
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
            ActionReport report = context.getActionReport();
            boolean reportErrorsInTopReport = false;
            if (!reportErrorsInTopReport) {
                report = report.addSubActionsReport();
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
        }
    }
}

