/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.property.GetProperty;
import org.apache.tools.ant.property.ParseProperties;
import org.apache.tools.ant.types.PropertySet;

public final class ExpandProperties
extends BaseFilterReader
implements ChainableReader {
    private static final int EOF = -1;
    private char[] buffer;
    private int index;
    private PropertySet propertySet;

    public ExpandProperties() {
    }

    public ExpandProperties(Reader in) {
        super(in);
    }

    public void add(PropertySet propertySet) {
        if (this.propertySet != null) {
            throw new BuildException("expandproperties filter accepts only one propertyset");
        }
        this.propertySet = propertySet;
    }

    @Override
    public int read() throws IOException {
        if (this.index > -1) {
            if (this.buffer == null) {
                GetProperty getProperty;
                String data = this.readFully();
                Project project = this.getProject();
                if (this.propertySet == null) {
                    getProperty = PropertyHelper.getPropertyHelper(project);
                } else {
                    final Properties props = this.propertySet.getProperties();
                    getProperty = new GetProperty(){

                        @Override
                        public Object getProperty(String name) {
                            return props.getProperty(name);
                        }
                    };
                }
                Object expanded = new ParseProperties(project, PropertyHelper.getPropertyHelper(project).getExpanders(), getProperty).parseProperties(data);
                char[] cArray = this.buffer = expanded == null ? new char[]{} : expanded.toString().toCharArray();
            }
            if (this.index < this.buffer.length) {
                return this.buffer[this.index++];
            }
            this.index = -1;
        }
        return -1;
    }

    @Override
    public Reader chain(Reader rdr) {
        ExpandProperties newFilter = new ExpandProperties(rdr);
        newFilter.setProject(this.getProject());
        newFilter.add(this.propertySet);
        return newFilter;
    }
}

