/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-virtual-server")
@PerLookup
@I18n(value="delete.virtual.server")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteVirtualServer
implements AdminCommand {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="virtual_server_id", primary=true)
    String vsid;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    private HttpService httpService;
    private NetworkConfig networkConfig;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        this.httpService = this.config.getHttpService();
        this.networkConfig = this.config.getNetworkConfig();
        if (!this.exists()) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00044"), this.vsid));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String referencedBy = this.getReferencingListener();
        if (referencedBy != null && referencedBy.length() != 0) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00045"), this.vsid, referencedBy));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ArrayList<ApplicationRef> appRefs = new ArrayList<ApplicationRef>();
            for (ApplicationRef appRef : this.server.getApplicationRef()) {
                if (appRef.getVirtualServers() == null || !appRef.getVirtualServers().contains(this.vsid)) continue;
                appRefs.add(appRef);
            }
            ConfigBeanProxy[] proxies = new ConfigBeanProxy[appRefs.size() + 1];
            proxies[0] = this.httpService;
            for (int i = 0; i < appRefs.size(); ++i) {
                proxies[i + 1] = (ConfigBeanProxy)appRefs.get(i);
            }
            ConfigSupport.apply((ConfigCode)new ConfigUpdate(this.vsid), (ConfigBeanProxy[])proxies);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00043"), this.vsid));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean exists() {
        if (this.vsid == null || this.httpService == null) {
            return false;
        }
        List list = this.httpService.getVirtualServer();
        for (VirtualServer vs : list) {
            String currId = vs.getId();
            if (currId == null || !currId.equals(this.vsid)) continue;
            return true;
        }
        return false;
    }

    private String getReferencingListener() {
        if (this.networkConfig != null) {
            List list = this.networkConfig.getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : list) {
                String virtualServer = listener.findHttpProtocol().getHttp().getDefaultVirtualServer();
                if (virtualServer == null || !virtualServer.equals(this.vsid)) continue;
                return listener.getName();
            }
        }
        return null;
    }

    private static class ConfigUpdate
    implements ConfigCode {
        private String vsid;

        private ConfigUpdate(String vsid) {
            this.vsid = vsid;
        }

        public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
            List list = ((HttpService)proxies[0]).getVirtualServer();
            for (VirtualServer item : list) {
                String currId = item.getId();
                if (currId == null || !currId.equals(this.vsid)) continue;
                list.remove(item);
                break;
            }
            if (proxies.length > 1) {
                for (int i = 1; i < proxies.length; ++i) {
                    ApplicationRef appRef = (ApplicationRef)proxies[i];
                    StringBuilder newList = new StringBuilder();
                    StringTokenizer st = new StringTokenizer(appRef.getVirtualServers(), ",");
                    while (st.hasMoreTokens()) {
                        String id = st.nextToken();
                        if (id.equals(this.vsid)) continue;
                        if (newList.length() > 0) {
                            newList.append(",");
                        }
                        newList.append(id);
                    }
                    appRef.setVirtualServers(newList.toString());
                }
            }
            return list;
        }
    }
}

