/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Validator;
import org.glassfish.api.ExecutionContext;
import org.glassfish.api.Param;
import org.glassfish.api.ParamDefaultCalculator;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.ParamTokenizer;
import org.glassfish.common.util.admin.UnacceptableValueException;
import org.glassfish.hk2.api.MultiException;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.InjectionResolver;

public class MapInjectionResolver
extends InjectionResolver<Param> {
    private final CommandModel model;
    private final ParameterMap parameters;
    private ExecutionContext context = null;
    private final MultiMap<String, File> optionNameToUploadedFileMap;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MapInjectionResolver.class);
    private static Validator beanValidator = null;

    public MapInjectionResolver(CommandModel model, ParameterMap parameters) {
        this(model, parameters, null);
    }

    public MapInjectionResolver(CommandModel model, ParameterMap parameters, MultiMap<String, File> optionNameToUploadedFileMap) {
        super(Param.class);
        this.model = model;
        this.parameters = parameters;
        this.optionNameToUploadedFileMap = optionNameToUploadedFileMap;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    public boolean isOptional(AnnotatedElement element, Param annotation) {
        String name = CommandModel.getParamName((Param)annotation, (AnnotatedElement)element);
        CommandModel.ParamModel param = this.model.getModelFor(name);
        return param.getParam().optional();
    }

    public <V> V getValue(Object component, AnnotatedElement target, Type genericType, Class<V> type) throws MultiException {
        List value;
        Param param = target.getAnnotation(Param.class);
        String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
        if (param.primary() && (value = this.parameters.get((Object)"DEFAULT")) != null && value.size() > 0) {
            List filePaths = MapInjectionResolver.getUploadedFileParamValues("DEFAULT", type, this.optionNameToUploadedFileMap);
            if (filePaths != null) {
                value = filePaths;
                this.parameters.set((Object)"DEFAULT", value);
            } else {
                for (String s : value) {
                    MapInjectionResolver.checkAgainstAcceptableValues(target, s);
                }
            }
            this.parameters.set((Object)paramName, value);
            Object paramValue = MapInjectionResolver.convertListToObject(target, type, value);
            return (V)paramValue;
        }
        if (param.multiple()) {
            value = this.parameters.get((Object)paramName);
            if (value != null && value.size() > 0) {
                List<String> filePaths = MapInjectionResolver.getUploadedFileParamValues(paramName, type, this.optionNameToUploadedFileMap);
                if (filePaths != null) {
                    value = filePaths;
                    this.parameters.set((Object)paramName, value);
                } else {
                    for (String s : value) {
                        MapInjectionResolver.checkAgainstAcceptableValues(target, s);
                    }
                }
            }
            this.parameters.set((Object)paramName, (Collection)value);
            Object paramValue = MapInjectionResolver.convertListToObject(target, type, value);
            return (V)paramValue;
        }
        String paramValueStr = MapInjectionResolver.getParamValueString(this.parameters, param, target, this.context);
        String fileParamValueStr = MapInjectionResolver.getUploadedFileParamValue(paramName, type, this.optionNameToUploadedFileMap);
        if (fileParamValueStr != null) {
            paramValueStr = fileParamValueStr;
            this.parameters.set((Object)paramName, (Object)paramValueStr);
        }
        MapInjectionResolver.checkAgainstAcceptableValues(target, paramValueStr);
        return (V)(paramValueStr != null ? MapInjectionResolver.convertStringToObject(target, type, paramValueStr) : MapInjectionResolver.getParamField(component, target));
    }

    public static String getUploadedFileParamValue(String fieldName, Class fieldType, MultiMap<String, File> optionNameToFileMap) {
        if (optionNameToFileMap == null) {
            return null;
        }
        File uploadedFile = (File)optionNameToFileMap.getOne((Object)fieldName);
        if (uploadedFile != null && fieldType.isAssignableFrom(File.class)) {
            return uploadedFile.getAbsolutePath();
        }
        return null;
    }

    public static List<String> getUploadedFileParamValues(String fieldName, Class fieldType, MultiMap<String, File> optionNameToFileMap) {
        if (optionNameToFileMap == null) {
            return null;
        }
        List uploadedFiles = optionNameToFileMap.get((Object)fieldName);
        if (uploadedFiles != null && uploadedFiles.size() > 0 && (fieldType.isAssignableFrom(File.class) || fieldType.isAssignableFrom(File[].class))) {
            ArrayList<String> paths = new ArrayList<String>(uploadedFiles.size());
            for (File f : uploadedFiles) {
                paths.add(f.getAbsolutePath());
            }
            return paths;
        }
        return null;
    }

    static String getParamValueString(ParameterMap parameters, Param param, AnnotatedElement target, ExecutionContext context) {
        Class dc;
        String paramValueStr = MapInjectionResolver.getParameterValue(parameters, CommandModel.getParamName((Param)param, (AnnotatedElement)target), true);
        if (paramValueStr == null && param.alias().length() > 0) {
            paramValueStr = MapInjectionResolver.getParameterValue(parameters, param.alias(), true);
        }
        if (paramValueStr == null) {
            paramValueStr = (String)parameters.getOne((Object)param.shortName());
        }
        if (paramValueStr == null) {
            String defaultValue = param.defaultValue();
            String string = paramValueStr = defaultValue.equals("") ? null : defaultValue;
        }
        if (paramValueStr == null && (dc = param.defaultCalculator()) != ParamDefaultCalculator.class) {
            try {
                ParamDefaultCalculator pdc = (ParamDefaultCalculator)dc.newInstance();
                paramValueStr = pdc.defaultValue(context);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(MapInjectionResolver.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(MapInjectionResolver.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return paramValueStr;
    }

    static Object getParamField(Object component, AnnotatedElement annotated) {
        try {
            if (annotated instanceof Field) {
                final Field field = (Field)annotated;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                return ((Field)annotated).get(component);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getParameterValue(ParameterMap params, String key, boolean ignoreCase) {
        if (ignoreCase) {
            for (Map.Entry entry : params.entrySet()) {
                String paramName = (String)entry.getKey();
                if (!paramName.equalsIgnoreCase(key)) continue;
                key = paramName;
                break;
            }
        }
        return (String)params.getOne((Object)key);
    }

    static Object convertStringToObject(AnnotatedElement target, Class type, String paramValStr) {
        Param param = target.getAnnotation(Param.class);
        String[] paramValue = paramValStr;
        if (type.isAssignableFrom(String.class)) {
            paramValue = paramValStr;
        } else if (type.isAssignableFrom(Properties.class)) {
            paramValue = MapInjectionResolver.convertStringToProperties(paramValStr, param.separator());
        } else if (type.isAssignableFrom(List.class)) {
            paramValue = MapInjectionResolver.convertStringToList(paramValStr, param.separator());
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
            paramValue = MapInjectionResolver.convertStringToBoolean(paramName, paramValStr);
        } else if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) {
            String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
            paramValue = MapInjectionResolver.convertStringToInteger(paramName, paramValStr);
        } else if (type.isAssignableFrom(String[].class)) {
            paramValue = MapInjectionResolver.convertStringToStringArray(paramValStr, param.separator());
        } else if (type.isAssignableFrom(File.class)) {
            return new File(paramValStr);
        }
        return paramValue;
    }

    public static Object convertListToObject(AnnotatedElement target, Class type, List<String> paramValList) {
        Param param = target.getAnnotation(Param.class);
        if (!param.multiple()) {
            if (paramValList.size() == 1) {
                return MapInjectionResolver.convertStringToObject(target, type, paramValList.get(0));
            }
            throw new UnacceptableValueException(localStrings.getLocalString("TooManyValues", "Invalid parameter: {0}.  This parameter may not have more than one value.", CommandModel.getParamName((Param)param, (AnnotatedElement)target)));
        }
        Object paramValue = paramValList;
        if (!type.isAssignableFrom(List.class)) {
            if (type.isAssignableFrom(String[].class)) {
                paramValue = paramValList.toArray(new String[paramValList.size()]);
            } else if (type.isAssignableFrom(File[].class)) {
                paramValue = MapInjectionResolver.convertListToFiles((List<String>)paramValList);
            } else if (type.isAssignableFrom(Properties.class)) {
                paramValue = MapInjectionResolver.convertListToProperties((List<String>)paramValList);
            }
        }
        return paramValue;
    }

    private static Boolean convertStringToBoolean(String paramName, String s) {
        if (!MapInjectionResolver.ok(s)) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return Boolean.FALSE;
        }
        String msg = localStrings.getLocalString("UnacceptableBooleanValue", "Invalid parameter: {0}.  This boolean option must be set (case insensitive) to true or false.  Its value was set to {1}", paramName, s);
        throw new UnacceptableValueException(msg);
    }

    private static Integer convertStringToInteger(String paramName, String s) {
        try {
            return new Integer(s);
        }
        catch (Exception ex) {
            String msg = localStrings.getLocalString("UnacceptableIntegerValue", "Invalid parameter: {0}.  This integer option must be set to a valid integer.\nIts value was set to {1}", paramName, s);
            throw new UnacceptableValueException(msg);
        }
    }

    static Properties convertStringToProperties(String propsString, char sep) {
        Properties properties = new Properties();
        if (propsString != null) {
            ParamTokenizer stoken = new ParamTokenizer(propsString, sep);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextTokenKeepEscapes();
                ParamTokenizer nameTok = new ParamTokenizer(token, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken().trim();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (name == null) {
                    throw new IllegalArgumentException(localStrings.getLocalString("PropertyMissingName", "Invalid property syntax, missing property name", propsString));
                }
                if (value == null) {
                    throw new IllegalArgumentException(localStrings.getLocalString("PropertyMissingValue", "Invalid property syntax, missing property value", token));
                }
                if (nameTok.hasMoreTokens()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("PropertyExtraEquals", "Invalid property syntax, \"=\" in value", token));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    private static File[] convertListToFiles(List<String> filesList) {
        File[] files = new File[filesList.size()];
        for (int i = 0; i < filesList.size(); ++i) {
            files[i] = new File(filesList.get(i));
        }
        return files;
    }

    private static Properties convertListToProperties(List<String> propsList) {
        Properties properties = new Properties();
        if (propsList != null) {
            for (String prop : propsList) {
                ParamTokenizer nameTok = new ParamTokenizer(prop, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException(localStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax.", prop));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    static List<String> convertStringToList(String listString, char sep) {
        ArrayList<String> list = new ArrayList<String>();
        if (listString != null) {
            ParamTokenizer ptoken = new ParamTokenizer(listString, sep);
            while (ptoken.hasMoreTokens()) {
                String token = ptoken.nextToken();
                list.add(token);
            }
        }
        return list;
    }

    static String[] convertStringToStringArray(String arrayString, char sep) {
        ParamTokenizer paramTok = new ParamTokenizer(arrayString, sep);
        ArrayList<String> strs = new ArrayList<String>();
        while (paramTok.hasMoreTokens()) {
            strs.add(paramTok.nextToken());
        }
        return strs.toArray(new String[strs.size()]);
    }

    private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
        Param param = target.getAnnotation(Param.class);
        String acceptable = param.acceptableValues();
        String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
        if (MapInjectionResolver.ok(acceptable) && MapInjectionResolver.ok(paramValueStr)) {
            String[] ss;
            for (String s : ss = acceptable.split(",")) {
                if (!paramValueStr.equals(s.trim())) continue;
                return;
            }
            throw new UnacceptableValueException(localStrings.getLocalString("UnacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", paramName, paramValueStr, acceptable));
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

