/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.whitebox.DataElement;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISException;
import com.sun.ts.tests.common.connector.whitebox.TSXaTransaction;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TSResourceManager {
    private boolean opened = false;
    private Hashtable association = new Hashtable();

    public TSResourceManager() {
        this.openRM();
    }

    public void openRM() {
        if (!this.opened) {
            this.opened = true;
        }
    }

    public void closeRM() {
        this.opened = false;
        this.association.clear();
    }

    public void start(Xid xid, int flags, TSConnection con) throws XAException {
        System.out.println("start." + flags + "." + xid + "..." + con);
        this.sanityCheck(xid, flags, "start");
        if (flags == 0) {
            TSXaTransaction txn = new TSXaTransaction(xid);
            txn.setStatus(1);
            if (con != null) {
                txn.addConnection(con);
            }
            this.association.put(xid, txn);
        } else if (flags == 0x200000) {
            TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
            if (con != null) {
                txn.addConnection(con);
            }
            this.association.put(xid, txn);
        } else if (flags == 0x8000000) {
            TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
            txn.setStatus(1);
            this.association.put(xid, txn);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.sanityCheck(xid, flags, "end");
        int status = 0;
        if (flags == 0x20000000) {
            status = 3;
        }
        if (flags == 0x2000000) {
            status = 2;
        }
        if (flags == 0x4000000) {
            status = 4;
        }
        TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
        txn.setStatus(status);
        this.association.put(xid, txn);
    }

    public int prepare(Xid xid) throws XAException {
        int ret;
        this.sanityCheck(xid, 0, "prepare");
        TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
        try {
            ret = txn.prepare();
        }
        catch (XAException xe) {
            System.out.println("Self.rollbak");
            txn.rollback();
            this.association.remove(xid);
            throw xe;
        }
        txn.setStatus(5);
        this.association.put(xid, txn);
        return ret;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (onePhase) {
            this.sanityCheck(xid, 0, "1pccommit");
        } else {
            this.sanityCheck(xid, 0, "2pccommit");
        }
        TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
        if (txn != null) {
            try {
                txn.commit(onePhase);
            }
            catch (XAException eb) {
                throw new XAException(100);
            }
            catch (Exception e) {
                throw new XAException(-3);
            }
            finally {
                this.association.remove(xid);
            }
        }
    }

    public void rollback(Xid xid) throws XAException {
        this.sanityCheck(xid, 0, "rollback");
        TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
        if (txn != null) {
            try {
                txn.rollback();
            }
            catch (Exception e) {
                throw new XAException(-3);
            }
            finally {
                this.association.remove(xid);
            }
        }
    }

    int getTransactionStatus(TSConnection con) {
        Enumeration e = this.association.keys();
        while (e.hasMoreElements()) {
            Xid id = (Xid)e.nextElement();
            TSXaTransaction txn = (TSXaTransaction)this.association.get(id);
            Hashtable connections = txn.getConnections();
            Enumeration e1 = connections.keys();
            while (e1.hasMoreElements()) {
                TSConnection temp = (TSConnection)e1.nextElement();
                if (con != temp) continue;
                return txn.getStatus();
            }
        }
        return 0;
    }

    DataElement read(String key, TSConnection con) throws TSEISException {
        System.out.println("ResourceManager.read");
        Enumeration e = this.association.keys();
        while (e.hasMoreElements()) {
            Xid xid = (Xid)e.nextElement();
            TSXaTransaction txn = (TSXaTransaction)this.association.get(xid);
            Hashtable connections = txn.getConnections();
            if (!connections.containsKey(con)) continue;
            return txn.read(key);
        }
        return null;
    }

    private void sanityCheck(Xid xid, int flags, String operation) throws XAException {
        TSXaTransaction txn;
        if (operation != null && operation.equals("start")) {
            if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
                throw new XAException(-5);
            }
            if (flags == 0 && this.association.containsKey(xid)) {
                throw new XAException(-8);
            }
            if (flags == 0x200000) {
                if (!this.association.containsKey(xid)) {
                    throw new XAException(-5);
                }
                txn = (TSXaTransaction)this.association.get(xid);
                if (txn.getStatus() != 1 && txn.getStatus() != 4) {
                    throw new XAException(-6);
                }
            }
            if (flags == 0x8000000) {
                if (!this.association.containsKey(xid)) {
                    throw new XAException(-5);
                }
                txn = (TSXaTransaction)this.association.get(xid);
                if (txn.getStatus() != 2) {
                    throw new XAException(-6);
                }
            }
        }
        if (operation != null && operation.equals("end")) {
            if (flags != 0x2000000 && flags != 0x20000000 && flags != 0x4000000) {
                throw new XAException(-5);
            }
            if (!this.association.containsKey(xid)) {
                throw new XAException(-5);
            }
            txn = (TSXaTransaction)this.association.get(xid);
            if (txn.getStatus() != 1 && txn.getStatus() != 4) {
                throw new XAException(-6);
            }
        }
        if (operation != null && operation.equals("prepare") && (txn = (TSXaTransaction)this.association.get(xid)).getStatus() != 3 && txn.getStatus() != 4) {
            throw new XAException(-6);
        }
        if (operation != null && operation.equals("2pccommit") && (txn = (TSXaTransaction)this.association.get(xid)).getStatus() != 5) {
            throw new XAException(-6);
        }
        if (operation != null && operation.equals("1pccommit") && (txn = (TSXaTransaction)this.association.get(xid)).getStatus() != 4 && txn.getStatus() != 3) {
            throw new XAException(-6);
        }
        if (operation != null && operation.equals("rollback") && (txn = (TSXaTransaction)this.association.get(xid)) != null && txn.getStatus() != 5 && txn.getStatus() != 4 && txn.getStatus() != 3) {
            throw new XAException(-6);
        }
    }
}

