/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.regexp;

import com.oracle.wls.shaded.org.apache.regexp.CharacterIterator;
import java.io.IOException;
import java.io.Reader;

public final class ReaderCharacterIterator
implements CharacterIterator {
    private final Reader reader;
    private final StringBuffer buff;
    private boolean closed;

    public ReaderCharacterIterator(Reader reader) {
        this.reader = reader;
        this.buff = new StringBuffer(512);
        this.closed = false;
    }

    public char charAt(int n) {
        try {
            this.ensure(n);
            return this.buff.charAt(n);
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }

    private void ensure(int n) throws IOException {
        if (this.closed) {
            return;
        }
        if (n < this.buff.length()) {
            return;
        }
        this.read(n + 1 - this.buff.length());
    }

    public boolean isEnd(int n) {
        if (this.buff.length() > n) {
            return false;
        }
        try {
            this.ensure(n);
            return this.buff.length() <= n;
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }

    private int read(int n) throws IOException {
        if (this.closed) {
            return 0;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n3 = this.reader.read(cArray)) < 0) {
                this.closed = true;
                break;
            }
            this.buff.append(cArray, 0, n3);
        } while ((n2 += n3) < n);
        return n2;
    }

    private void readAll() throws IOException {
        while (!this.closed) {
            this.read(1000);
        }
    }

    public String substring(int n) {
        try {
            this.readAll();
            return this.buff.toString().substring(n);
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }

    public String substring(int n, int n2) {
        try {
            this.ensure(n + n2);
            return this.buff.toString().substring(n, n2);
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }
}

