/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json", "text/json", "*/*"})
public class JsonValueBodyReader
implements MessageBodyReader<JsonValue> {
    private final JsonReaderFactory rf = Json.createReaderFactory(null);
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(aClass) && JsonValueBodyReader.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    public JsonValue readFrom(Class<JsonValue> jsonValueClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try (JsonReader reader = this.rf.createReader(inputStream);){
            JsonValue jsonValue = reader.readValue();
            return jsonValue;
        }
    }
}

