/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.logging.annotation.LogMessageInfo;

public abstract class RootDeploymentDescriptor
extends Descriptor {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="invalidSpecVersion:  {0}", level="WARNING")
    private static final String INVALID_SPEC_VERSION = "NCLS-DEPLOYMENT-00046";
    protected String moduleID;
    private String specVersion;
    private String index = null;
    protected transient ClassLoader classLoader = null;
    protected Map<Class<? extends RootDeploymentDescriptor>, List<RootDeploymentDescriptor>> extensions = new HashMap<Class<? extends RootDeploymentDescriptor>, List<RootDeploymentDescriptor>>();
    protected ModuleDescriptor moduleDescriptor;
    private static final List<?> emptyList = Collections.emptyList();

    public RootDeploymentDescriptor() {
    }

    public RootDeploymentDescriptor(String name, String description) {
        super(name, description);
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public abstract String getModuleID();

    public abstract String getDefaultSpecVersion();

    public abstract boolean isEmpty();

    public String getSpecVersion() {
        if (this.specVersion == null) {
            this.specVersion = this.getDefaultSpecVersion();
        }
        try {
            Double.parseDouble(this.specVersion);
        }
        catch (NumberFormatException nfe) {
            deplLogger.log(Level.WARNING, INVALID_SPEC_VERSION, new Object[]{this.specVersion, this.getDefaultSpecVersion()});
            this.specVersion = this.getDefaultSpecVersion();
        }
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public abstract ArchiveType getModuleType();

    public DescriptorVisitor getTracerVisitor() {
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public void setDisplayName(String name) {
        super.setName(name);
    }

    @Override
    public String getDisplayName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        this.setModuleID(name);
    }

    @Override
    public String getName() {
        if (this.getModuleID() != null) {
            return this.getModuleID();
        }
        return this.getDisplayName();
    }

    public void setSchemaLocation(String schemaLocation) {
        this.addExtraAttribute("schema-location", schemaLocation);
    }

    public String getSchemaLocation() {
        return (String)this.getExtraAttribute("schema-location");
    }

    public ModuleDescriptor getModuleDescriptor() {
        if (this.moduleDescriptor == null) {
            this.moduleDescriptor = new ModuleDescriptor();
            this.moduleDescriptor.setModuleType(this.getModuleType());
            this.moduleDescriptor.setDescriptor(this);
        }
        return this.moduleDescriptor;
    }

    public void setModuleDescriptor(ModuleDescriptor descriptor) {
        this.moduleDescriptor = descriptor;
        for (List<RootDeploymentDescriptor> extByType : this.extensions.values()) {
            if (extByType == null) continue;
            for (RootDeploymentDescriptor ext : extByType) {
                ext.setModuleDescriptor(descriptor);
            }
        }
    }

    public abstract boolean isApplication();

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n Module Type = ").append(this.getModuleType());
        toStringBuffer.append("\n Module spec version = ").append(this.getSpecVersion());
        if (this.moduleID != null) {
            toStringBuffer.append("\n Module ID = ").append(this.moduleID);
        }
        if (this.getSchemaLocation() != null) {
            toStringBuffer.append("\n Client SchemaLocation = ").append(this.getSchemaLocation());
        }
    }

    public Collection<RootDeploymentDescriptor> getExtensionsDescriptors() {
        ArrayList<RootDeploymentDescriptor> flattened = new ArrayList<RootDeploymentDescriptor>();
        for (List<RootDeploymentDescriptor> extensionsByType : this.extensions.values()) {
            flattened.addAll(extensionsByType);
        }
        return Collections.unmodifiableCollection(flattened);
    }

    public <T extends RootDeploymentDescriptor> Collection<T> getExtensionsDescriptors(Class<T> type) {
        for (Map.Entry<Class<? extends RootDeploymentDescriptor>, List<RootDeploymentDescriptor>> entry : this.extensions.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey())) continue;
            return Collections.unmodifiableCollection((Collection)entry.getValue());
        }
        return emptyList;
    }

    public <T extends RootDeploymentDescriptor> T getExtensionsDescriptors(Class<? extends RootDeploymentDescriptor> type, String index) {
        for (RootDeploymentDescriptor rootDeploymentDescriptor : this.getExtensionsDescriptors(type)) {
            String extensionIndex = rootDeploymentDescriptor.index;
            if (!(index == null ? extensionIndex == null : index.equals(extensionIndex))) continue;
            return (T)rootDeploymentDescriptor;
        }
        return null;
    }

    public synchronized <T extends RootDeploymentDescriptor> void addExtensionDescriptor(Class<? extends RootDeploymentDescriptor> type, T instance, String index) {
        List<Object> values;
        if (this.extensions.containsKey(type)) {
            values = this.extensions.get(type);
        } else {
            values = new ArrayList();
            this.extensions.put(type, values);
        }
        instance.index = index;
        values.add(instance);
    }

    public boolean isExtensionDescriptor() {
        return this.getModuleDescriptor().getDescriptor() != this;
    }

    public RootDeploymentDescriptor getMainDescriptor() {
        if (this.isExtensionDescriptor()) {
            return this.getModuleDescriptor().getDescriptor();
        }
        return this;
    }
}

