/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.AttributeBean;
import com.sun.faces.config.beans.PropertyBean;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.HtmlTaglib12Generator;
import com.sun.faces.generate.PropertyManager;

public class HtmlTaglib21Generator
extends HtmlTaglib12Generator {
    public HtmlTaglib21Generator(PropertyManager propManager) {
        super(propManager);
        this.addImport("javax.el.*");
        this.addImport("javax.faces.validator.*");
        this.addImport("javax.faces.event.*");
        this.addImport("javax.faces.*");
    }

    public static void main(String[] args) {
        PropertyManager manager = PropertyManager.newInstance(args[0]);
        try {
            HtmlTaglib21Generator generator = new HtmlTaglib21Generator(manager);
            generator.generate(GeneratorUtil.getConfigBean(args[1]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void writeClassDeclaration() throws Exception {
        this.writer.writePublicClassDeclaration(this.tagClassName, "UIComponentELTag", null, false, false);
    }

    @Override
    protected void tagHandlerSetterMethods() throws Exception {
        this.writer.writeLineComment("Setter Methods");
        for (PropertyBean property : this.component.getProperties()) {
            if (property == null || !property.isTagAttribute()) continue;
            String propertyName = property.getPropertyName();
            String propertyType = property.getPropertyClass();
            if ("binding".equals(propertyName) || "id".equals(propertyName) || "rendered".equals(propertyName)) continue;
            if (property.isMethodExpressionEnabled()) {
                this.writer.writeWriteOnlyProperty(propertyName, "javax.el.MethodExpression");
                continue;
            }
            if (property.isValueExpressionEnabled()) {
                this.writer.writeWriteOnlyProperty(propertyName, "javax.el.ValueExpression");
                continue;
            }
            this.writer.writeWriteOnlyProperty(propertyName, propertyType);
        }
        for (AttributeBean attribute : this.renderer.getAttributes()) {
            if (attribute == null || !attribute.isTagAttribute()) continue;
            String attributeName = attribute.getAttributeName();
            this.writer.writeWriteOnlyProperty(attributeName, "javax.el.ValueExpression");
        }
        this.writer.write("\n");
    }

    @Override
    protected void tagHanderSetPropertiesMethod() throws Exception {
        String componentType = this.component.getComponentType();
        String componentClass = this.component.getComponentClass();
        this.writer.fwrite("protected void setProperties(UIComponent component) {\n");
        this.writer.indent();
        this.writer.fwrite("super.setProperties(component);\n");
        String iVar = GeneratorUtil.stripJavaxFacesPrefix(componentType).toLowerCase();
        this.writer.fwrite(componentClass + ' ' + iVar + " = null;\n");
        this.writer.fwrite("try {\n");
        this.writer.indent();
        this.writer.fwrite(iVar + " = (" + componentClass + ") component;\n");
        this.writer.outdent();
        this.writer.fwrite("} catch (ClassCastException cce) {\n");
        this.writer.indent();
        this.writer.fwrite("throw new IllegalStateException(\"Component \" + component.toString() + \" not expected type.  Expected: " + componentClass + ".  Perhaps you're missing a tag?\");\n");
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
        if (HtmlTaglib21Generator.isValueHolder(componentClass)) {
            this.writer.fwrite("if (converter != null) {\n");
            this.writer.indent();
            this.writer.fwrite("if (!converter.isLiteralText()) {\n");
            this.writer.indent();
            this.writer.fwrite(iVar + ".setValueExpression(\"converter\", converter);\n");
            this.writer.outdent();
            this.writer.fwrite("} else {\n");
            this.writer.indent();
            this.writer.fwrite("Converter conv = FacesContext.getCurrentInstance().getApplication().createConverter(converter.getExpressionString());\n");
            this.writer.fwrite(iVar + ".setConverter(conv);\n");
            this.writer.outdent();
            this.writer.fwrite("}\n");
            this.writer.outdent();
            this.writer.fwrite("}\n\n");
        }
        for (PropertyBean property : this.component.getProperties()) {
            String propertyName;
            if (property == null || !property.isTagAttribute() || "binding".equals(propertyName = property.getPropertyName()) || "id".equals(propertyName) || "rendered".equals(propertyName) || "converter".equals(propertyName)) continue;
            String ivar = HtmlTaglib21Generator.mangle(propertyName);
            String comp = GeneratorUtil.stripJavaxFacesPrefix(componentType).toLowerCase();
            String capPropName = HtmlTaglib21Generator.capitalize(propertyName);
            if (property.isValueExpressionEnabled()) {
                this.writer.fwrite("if (" + ivar + " != null) {\n");
                this.writer.indent();
                this.writer.fwrite(comp);
                if ("_for".equals(ivar)) {
                    this.writer.write(".setValueExpression(\"for\", " + ivar + ");\n");
                } else {
                    this.writer.write(".setValueExpression(\"" + ivar + "\", " + ivar + ");\n");
                }
                this.writer.outdent();
                this.writer.fwrite("}\n");
                continue;
            }
            if (property.isMethodExpressionEnabled()) {
                if ("action".equals(ivar)) {
                    this.writer.fwrite("if (" + ivar + " != null) {\n");
                    this.writer.indent();
                    this.writer.fwrite(comp + ".setActionExpression(" + ivar + ");\n");
                    this.writer.outdent();
                    this.writer.fwrite("}\n");
                    continue;
                }
                this.writer.fwrite("if (" + ivar + " != null) {\n");
                this.writer.indent();
                this.writer.fwrite(comp + ".add" + HtmlTaglib21Generator.capitalize(ivar) + "(new MethodExpression" + HtmlTaglib21Generator.capitalize(ivar) + '(' + ivar + "));\n");
                this.writer.outdent();
                this.writer.fwrite("}\n");
                continue;
            }
            this.writer.fwrite("if (" + ivar + " != null) {\n");
            this.writer.indent();
            this.writer.fwrite(comp + ".set" + capPropName + "(" + ivar + ");\n");
            this.writer.outdent();
            this.writer.fwrite("}\n");
        }
        for (AttributeBean attribute : this.renderer.getAttributes()) {
            if (attribute == null || !attribute.isTagAttribute()) continue;
            String attributeName = attribute.getAttributeName();
            String ivar = HtmlTaglib21Generator.mangle(attributeName);
            String comp = GeneratorUtil.stripJavaxFacesPrefix(componentType).toLowerCase();
            this.writer.fwrite("if (" + ivar + " != null) {\n");
            this.writer.indent();
            this.writer.fwrite(comp);
            if ("_for".equals(ivar)) {
                this.writer.write(".setValueExpression(\"for\", " + ivar + ");\n");
            } else {
                this.writer.write(".setValueExpression(\"" + ivar + "\", " + ivar + ");\n");
            }
            this.writer.outdent();
            this.writer.fwrite("}\n");
        }
        this.writer.outdent();
        this.writer.fwrite("}\n");
    }
}

