/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.AppException;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageXAResource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextProvider;
import javax.transaction.xa.XAResource;

public class LocalTxMessageWork
implements Work,
WorkContextProvider {
    private String name;
    private boolean stop = false;
    private MessageEndpointFactory factory;
    private LocalTxMessageXAResource msgxa = new LocalTxMessageXAResource("LocalTxMessageXAResource");
    private MessageEndpoint ep2;
    private List<WorkContext> contextsList = new ArrayList<WorkContext>();
    private BootstrapContext ctx = null;
    private final String SICFAIL = "mdb not executed with proper SIC principal";
    private final String SICPASS = "mdb executed with proper SIC principal";

    public LocalTxMessageWork(String name, MessageEndpointFactory factory) {
        this.factory = factory;
        this.name = name;
        this.debug("LocalTxMessageWork.constructor");
    }

    public void setBootstrapContext(BootstrapContext bsc) {
        this.ctx = bsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSICMsgCheck(MessageEndpoint ep, Method onMessage) {
        try {
            ep.beforeDelivery(onMessage);
            String message = "ROLE: ADM";
            ((TSMessageListenerInterface)ep).onMessage(message);
        }
        catch (AppException ex) {
            String str = ex.getMessage();
            this.debug("str = " + str);
            if (str != null && str.equals("MDB-SIC SUCCESS")) {
                this.debug("mdb executed with proper SIC principal");
                ConnectorStatus.getConnectorStatus().logState("mdb executed with proper SIC principal");
            } else {
                this.debug("MDB-SIC FAILED due to AppException with msg: " + ex.getMessage());
                this.debug("mdb not executed with proper SIC principal");
                ex.printStackTrace();
                ConnectorStatus.getConnectorStatus().logState("mdb not executed with proper SIC principal");
            }
        }
        catch (Exception e) {
            this.debug("MDB-SIC FAILED due to Exception with msg: " + e.getMessage());
            this.debug("mdb not executed with proper SIC principal");
            e.printStackTrace();
            ConnectorStatus.getConnectorStatus().logState("mdb not executed with proper SIC principal");
        }
        finally {
            try {
                ep.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public void run() {
        while (!this.stop) {
            try {
                this.debug("Inside the LocalTxMessageWork run ");
                MessageEndpoint ep = this.factory.createEndpoint(null);
                MessageEndpoint ep1 = this.factory.createEndpoint(null);
                this.ep2 = this.factory.createEndpoint(null);
                MessageEndpoint xaep = this.factory.createEndpoint((XAResource)this.msgxa);
                if (ep != null && !ep.equals(ep1)) {
                    ConnectorStatus.getConnectorStatus().logState("LocalTx Unique MessageEndpoint returned");
                }
                this.chkMessageEndpointImpl(ep);
                Method onMessage = this.getOnMessageMethod();
                ep.beforeDelivery(onMessage);
                ((TSMessageListenerInterface)ep).onMessage("LocalTx Message To MDB");
                ep.afterDelivery();
                ConnectorStatus.getConnectorStatus().logState("LocalTx Message To MDB");
                this.doSICMsgCheck(ep, onMessage);
                Method onMessagexa = this.getOnMessageMethod();
                xaep.beforeDelivery(onMessagexa);
                ((TSMessageListenerInterface)xaep).onMessage("LocalTx Non Transacted Message To MDB1");
                xaep.afterDelivery();
                ConnectorStatus.getConnectorStatus().logState("LocalTx Non Transacted Message To MDB1");
                System.out.println("Calling sysExp()");
                this.callSysExp();
                this.callAppExp();
                boolean de = this.factory.isDeliveryTransacted(onMessagexa);
                if (de) break;
                System.out.println("MDB1 delivery is not transacted");
                ConnectorStatus.getConnectorStatus().logState("LocalTx MDB1 delivery is not transacted");
                break;
            }
            catch (AppException ex) {
                ex.printStackTrace();
            }
            catch (UnavailableException ex) {
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException nse) {
                nse.printStackTrace();
            }
            catch (ResourceException re) {
                re.printStackTrace();
            }
        }
    }

    public void callSysExp() {
        try {
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw EJBException from NotSupported");
        }
        catch (NoSuchMethodException e) {
            this.debug("LocalTxMessageWork: NoSuchMethodException");
            e.getMessage();
            e.printStackTrace();
        }
        catch (UnavailableException e) {
            this.debug("LocalTxMessageWork: UnavailableException");
            e.printStackTrace();
        }
        catch (ResourceException re) {
            this.debug("LocalTxMessageWork: ResourceException");
            re.printStackTrace();
        }
        catch (AppException ae) {
            this.debug("LocalTxMessageWork: AppException");
            ae.printStackTrace();
        }
        catch (Exception e) {
            this.debug("EJBException thrown by NotSupported MDB");
            ConnectorStatus.getConnectorStatus().logState("EJBException thrown by NotSupported");
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public void callAppExp() {
        try {
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw AppException from NotSupported");
        }
        catch (AppException ejbe) {
            this.debug("AppException thrown by NotSupported MDB");
            ConnectorStatus.getConnectorStatus().logState("AppException thrown by NotSupported");
        }
        catch (NoSuchMethodException ns) {
            ns.printStackTrace();
        }
        catch (ResourceException re) {
            re.printStackTrace();
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    private void chkMessageEndpointImpl(MessageEndpoint ep) {
        if (ep instanceof MessageEndpoint && ep instanceof TSMessageListenerInterface) {
            ConnectorStatus.getConnectorStatus().logState("LocalTx MessageEndpoint interface implemented");
            ConnectorStatus.getConnectorStatus().logState("LocalTx TSMessageListener interface implemented");
        } else {
            ConnectorStatus.getConnectorStatus().logState("MessageEndpoint and TSMessageListenerInterface not implemented");
        }
    }

    public List<WorkContext> getWorkContexts() {
        return this.contextsList;
    }

    public void addWorkContext(WorkContext ic) {
        this.contextsList.add(ic);
    }

    public void release() {
    }

    public void stop() {
        this.stop = true;
    }

    public String toString() {
        return this.name;
    }

    private void debug(String val) {
        Debug.trace(val);
    }
}

