/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Pattern;
import org.glassfish.grizzly.config.dom.NetworkAddress;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.Range;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface NetworkListener
extends ConfigBeanProxy,
PropertyBag {
    public static final boolean ENABLED = true;
    public static final boolean JK_ENABLED = false;
    public static final String DEFAULT_ADDRESS = "0.0.0.0";
    public static final String DEFAULT_CONFIGURATION_FILE = "${com.sun.aas.instanceRoot}/config/glassfish-jk.properties";
    public static final String TYPE_PATTERN = "(standard|proxy)";
    public static final String DEFAULT_TYPE = "standard";

    @Attribute(defaultValue="0.0.0.0")
    @NetworkAddress
    public String getAddress();

    public void setAddress(String var1);

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1);

    @Attribute(defaultValue="${com.sun.aas.instanceRoot}/config/glassfish-jk.properties")
    public String getJkConfigurationFile();

    public void setJkConfigurationFile(String var1);

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getJkEnabled();

    public void setJkEnabled(String var1);

    @Attribute(required=true, key=true)
    public String getName();

    public void setName(String var1);

    @Attribute(required=true, dataType=String.class, defaultValue="standard")
    @Pattern(regexp="(standard|proxy)")
    public @Pattern(regexp="(standard|proxy)") String getType();

    public void setType(String var1);

    @Attribute(required=true, dataType=Integer.class)
    @Range(min=0, max=65535)
    public String getPort();

    public void setPort(String var1);

    @Attribute(required=true)
    public String getProtocol();

    public void setProtocol(String var1);

    @Attribute
    public String getThreadPool();

    public void setThreadPool(String var1);

    @Attribute(required=true)
    public String getTransport();

    public void setTransport(String var1);

    @DuckTyped
    public Protocol findHttpProtocol();

    @DuckTyped
    public String findHttpProtocolName();

    @DuckTyped
    public Protocol findProtocol();

    @DuckTyped
    public ThreadPool findThreadPool();

    @DuckTyped
    public Transport findTransport();

    @DuckTyped
    public NetworkListeners getParent();

    public static class Duck {
        public static Protocol findHttpProtocol(NetworkListener listener) {
            return Duck.findHttpProtocol(new HashSet<String>(), Duck.findProtocol(listener));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Protocol findHttpProtocol(Set<String> tray, Protocol protocol) {
            if (protocol == null) {
                return null;
            }
            String protocolName = protocol.getName();
            if (tray.contains(protocolName)) {
                throw new IllegalStateException("Loop found in Protocol definition. Protocol name: " + protocol.getName());
            }
            if (protocol.getHttp() != null) {
                return protocol;
            }
            if (protocol.getPortUnification() != null) {
                List<ProtocolFinder> finders = protocol.getPortUnification().getProtocolFinder();
                tray.add(protocolName);
                try {
                    Protocol foundHttpProtocol = null;
                    for (ProtocolFinder finder : finders) {
                        Protocol httpProtocol;
                        Protocol subProtocol = finder.findProtocol();
                        if (subProtocol == null || (httpProtocol = Duck.findHttpProtocol(tray, subProtocol)) == null) continue;
                        foundHttpProtocol = httpProtocol;
                    }
                    Iterator<ProtocolFinder> iterator = foundHttpProtocol;
                    return iterator;
                }
                finally {
                    tray.remove(protocolName);
                }
            }
            return null;
        }

        public static String findHttpProtocolName(NetworkListener listener) {
            Protocol httpProtocol = Duck.findHttpProtocol(listener);
            if (httpProtocol != null) {
                return httpProtocol.getName();
            }
            return null;
        }

        public static Protocol findProtocol(NetworkListener listener) {
            return listener.getParent().getParent().findProtocol(listener.getProtocol());
        }

        public static ThreadPool findThreadPool(NetworkListener listener) {
            NetworkListeners listeners = listener.getParent();
            List<ThreadPool> list = listeners.getThreadPool();
            if (list == null || list.isEmpty()) {
                ConfigBeanProxy parent = listener.getParent().getParent().getParent();
                Dom proxy = Dom.unwrap((ConfigBeanProxy)parent).element("thread-pools");
                List domList = proxy.nodeElements("thread-pool");
                list = new ArrayList<ThreadPool>(domList.size());
                for (Dom dom : domList) {
                    list.add((ThreadPool)dom.createProxy());
                }
            }
            for (ThreadPool pool : list) {
                if (!listener.getThreadPool().equals(pool.getName())) continue;
                return pool;
            }
            return null;
        }

        public static Transport findTransport(NetworkListener listener) {
            List<Transport> list = listener.getParent().getParent().getTransports().getTransport();
            for (Transport transport : list) {
                if (!listener.getTransport().equals(transport.getName())) continue;
                return transport;
            }
            return null;
        }

        public static NetworkListeners getParent(NetworkListener listener) {
            return (NetworkListeners)listener.getParent(NetworkListeners.class);
        }
    }
}

