/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class FileClassLoader
extends ClassLoader {
    String codebase;
    Hashtable cache = new Hashtable();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FileClassLoader.class);

    public FileClassLoader(String codebase) {
        this.codebase = codebase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(String name) throws IOException {
        File wf;
        String sep = System.getProperty("file.separator");
        String c = name.replace('.', sep.charAt(0)) + ".class";
        File file = new File(this.codebase + sep + c);
        if (!file.exists() && (wf = new File(this.codebase + sep + "WEB-INF" + sep + "classes" + sep + c)).exists()) {
            file = wf;
        }
        byte[] buf = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            int avail = fis.available();
            buf = new byte[avail];
            fis.read(buf);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getClassName(File f) throws IOException, ClassFormatError {
        FileInputStream fis = null;
        byte[] buf = null;
        int avail = 0;
        try {
            fis = new FileInputStream(f);
            avail = fis.available();
            buf = new byte[avail];
            fis.read(buf);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        Class<?> c = super.defineClass(null, buf, 0, avail);
        return c.getName();
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.cache.get(name);
        if (c == null) {
            try {
                byte[] data = this.loadClassData(name);
                c = this.defineClass(null, data, 0, data.length);
                if (!name.equals(c.getName())) {
                    throw new ClassNotFoundException(localStrings.getLocalString("classloader.wrongpackage", "", new Object[]{name, c.getName()}));
                }
            }
            catch (Exception ex) {
                c = Class.forName(name);
            }
            this.cache.put(name, c);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public String toString() {
        return "FileClassLoader: Codebase = " + this.codebase + "\n";
    }
}

