/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="change-admin-password")
@PerLookup
@I18n(value="change.admin.password")
@ExecuteOn(value={RuntimeType.ALL})
public class ChangeAdminPassword
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ChangeAdminPassword.class);
    @Param(name="password", password=true)
    private String oldpassword;
    @Param(name="newpassword", password=true)
    private String newpassword;
    @Param(name="username", primary=true)
    private String userName;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    private AdminService adminService;
    private SecureAdmin secureAdmin = null;
    private Config config;
    @AccessRequired.To(value={"update"})
    private AuthRealm fileAuthRealm;

    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.secureAdmin = this.domain.getSecureAdmin();
        if (SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin) && (this.newpassword == null || this.newpassword.isEmpty())) {
            report.setMessage(localStrings.getLocalString("null_empty_password", "The new password is null or empty"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        List configList = this.configs.getConfig();
        this.config = (Config)configList.get(0);
        SecurityService securityService = this.config.getSecurityService();
        this.fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(this.adminService.getAuthRealmName())) continue;
            this.fileAuthRealm = authRealm;
            break;
        }
        if (this.fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("change.admin.password.adminrealmnotfound", "Server Error: There is no admin realm to perform this operation"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String fileRealmClassName = this.fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("change.admin.password.adminrealmnotsupported", "Configured admin realm is not supported."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : this.fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("change.admin.password.keyfilenotfound", "There is no physical file associated with admin realm"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            this.realmsManager.createRealms(this.config);
            fr = (FileRealm)this.realmsManager.getFromLoadedRealms(this.config.getName(), this.fileAuthRealm.getName());
            if (fr == null) {
                throw new NoSuchRealmException(this.fileAuthRealm.getName());
            }
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.realmnotsupported", "Configured admin realm does not exist.") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            Enumeration en = fr.getGroupNames(this.userName);
            int size = 0;
            while (en.hasMoreElements()) {
                ++size;
                en.nextElement();
            }
            String[] groups = new String[size];
            en = fr.getGroupNames(this.userName);
            for (int i = 0; i < size; ++i) {
                groups[i] = (String)en.nextElement();
            }
            fr.updateUser(this.userName, this.userName, this.newpassword.toCharArray(), groups);
            fr.persist();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.userupdatefailed", "Password change failed for user named {0}", new Object[]{this.userName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

