/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class DeployUtil {
    public static boolean reloadApplication(String appName, List<String> targets, HandlerContext handlerCtx) {
        try {
            String decodedName = URLDecoder.decode(appName, "UTF-8");
            List clusters = TargetUtil.getClusters();
            String clusterEndpoint = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
            String serverEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
            for (String targetName : targets) {
                String endpoint = clusters.contains(targetName) ? clusterEndpoint + targetName + "/application-ref/" + decodedName : serverEndpoint + targetName + "/application-ref/" + decodedName;
                String status = (String)RestUtil.getAttributesMap(endpoint).get("enabled");
                if (!Boolean.parseBoolean(status)) continue;
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("enabled", "false");
                RestUtil.restRequest(endpoint, attrs, "POST", null, false, true);
                attrs.put("enabled", "true");
                RestUtil.restRequest(endpoint, attrs, "POST", null, false, true);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleError(handlerCtx, ex.getMessage());
            return false;
        }
        return true;
    }

    public static List getApplicationTarget(String appName, String ref) {
        ArrayList<String> targets;
        block4: {
            targets = new ArrayList<String>();
            try {
                List clusters = TargetUtil.getClusters();
                for (String oneCluster : clusters) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref).keySet());
                    if (!appRefs.contains(appName)) continue;
                    targets.add(oneCluster);
                }
                List servers = TargetUtil.getStandaloneInstances();
                servers.add("server");
                for (String oneServer : servers) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref).keySet());
                    if (!appRefs.contains(appName)) continue;
                    targets.add(oneServer);
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.appTarget") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
        return targets;
    }

    public static List<Map> getRefEndpoints(String name, String ref) {
        ArrayList<Map> endpoints;
        block4: {
            endpoints = new ArrayList<Map>();
            try {
                String encodedName = URLEncoder.encode(name, "UTF-8");
                List clusters = TargetUtil.getClusters();
                for (String oneCluster : clusters) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref).keySet());
                    if (!appRefs.contains(name)) continue;
                    HashMap<String, String> aMap = new HashMap<String, String>();
                    aMap.put("endpoint", GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref + "/" + encodedName);
                    aMap.put("targetName", oneCluster);
                    endpoints.add(aMap);
                }
                List servers = TargetUtil.getStandaloneInstances();
                servers.add("server");
                for (String oneServer : servers) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref).keySet());
                    if (!appRefs.contains(name)) continue;
                    HashMap<String, String> aMap = new HashMap<String, String>();
                    aMap.put("endpoint", GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref + "/" + encodedName);
                    aMap.put("targetName", oneServer);
                    endpoints.add(aMap);
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getRefEndpoints") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
        return endpoints;
    }

    public static String getTargetEnableInfo(String appName, boolean useImage, boolean isApp) {
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        String enabled = "true";
        int numEnabled = 0;
        int numDisabled = 0;
        String ref = "application-ref";
        if (!isApp) {
            ref = "resource-ref";
        }
        if (clusters.isEmpty() && standalone.isEmpty()) {
            enabled = (String)RestUtil.getAttributesMap(prefix + "/servers/server/server/" + ref + "/" + appName).get("enabled");
            if (enabled == null) {
                enabled = (String)RestUtil.getAttributesMap(prefix + "/applications/application/" + appName).get("enabled");
            }
            if (useImage) {
                return Boolean.parseBoolean(enabled) ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            }
            return enabled;
        }
        standalone.add("server");
        List targetList = new ArrayList();
        try {
            targetList = DeployUtil.getApplicationTarget(URLDecoder.decode(appName, "UTF-8"), ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String oneTarget : targetList) {
            enabled = clusters.contains(oneTarget) ? (String)RestUtil.getAttributesMap(prefix + "/clusters/cluster/" + oneTarget + "/" + ref + "/" + appName).get("enabled") : (String)RestUtil.getAttributesMap(prefix + "/servers/server/" + oneTarget + "/" + ref + "/" + appName).get("enabled");
            if (Boolean.parseBoolean(enabled)) {
                ++numEnabled;
                continue;
            }
            ++numDisabled;
        }
        int numTargets = targetList.size();
        return numTargets == 0 ? GuiUtil.getMessage("deploy.noTarget") : GuiUtil.getMessage("deploy.someEnabled", new String[]{"" + numEnabled, "" + numTargets});
    }
}

