/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)JAXBException.test.xml	1.2 05/08/13 Evgueni Rouban
 * Generated from : api/jakarta_xml/bind/JAXBException/JAXBException.test.xml
 *
 * General tests of constructors and methods
 * General tests of constructors and methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.JAXBException;

import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class JAXBExceptionTests extends MultiTest {

    static final String msg = "test message";
    static final String err = "error code";
    static final Throwable linkedException = new Throwable();

    public static class PrintStackTraceDetector extends Throwable {
        public boolean printStackTraceCalled;
        public void printStackTrace(java.io.PrintStream s) {
            printStackTraceCalled = true;
            super.printStackTrace(s);
        }
        public void printStackTrace() {
            printStackTraceCalled = true;
            super.printStackTrace();
        }
    };

    /* standalone interface */
    public static void main(String argv[]) {
        JAXBExceptionTests test = new JAXBExceptionTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message),
     * Construct a JAXBException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor001() {
        JAXBException je = new JAXBException(msg);
        if (je.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + je.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and output values orientation
     * for public java.lang.String getErrorCode(),
     * <br><b>pre-conditions</b>: errorCode set to null,
     * <br><b>output</b>: null.
     */
    public Status Ctor002() {
        JAXBException je = new JAXBException(msg);
        if (je.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + je.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor003() {
        JAXBException je = new JAXBException(msg);
        if (je.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + je.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.String errorCode),
     * Construct a JAXBException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor004() {
        JAXBException je = new JAXBException(msg, err);
        if (je.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + je.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and output values orientation
     * for public java.lang.String getErrorCode(),
     * <br><b>pre-conditions</b>: errorCode set to a non-null value,
     * <br><b>output</b>: non-null.
     */
    public Status Ctor005() {
        JAXBException je = new JAXBException(msg, err);
        if (je.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + je.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.String errorCode),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor006() {
        JAXBException je = new JAXBException(msg, err);
        if (je.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + je.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a JAXBException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor007() {
        JAXBException je = new JAXBException(msg, err, linkedException);
        if (je.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + je.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.lang.Throwable getLinkedException(),
     * <br><b>pre-conditions</b>: linkedException set to a non-null value,
     * Get the linked exception..
     * <br><b>Expected output value</b>: the linkedException is what set
     */
    public Status Ctor008() {
        JAXBException je = new JAXBException(msg, err, linkedException);
        if (je.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + je.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a JAXBException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor009() {
        JAXBException je = new JAXBException(msg, err, linkedException);
        if (je.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + je.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.Throwable exception),
     * Construct a JAXBException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor010() {
        JAXBException je = new JAXBException(msg, linkedException);
        if (je.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + je.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor011() {
        JAXBException je = new JAXBException(msg, linkedException);
        if (je.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + je.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.String message, java.lang.Throwable exception),
     * Construct a JAXBException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor012() {
        JAXBException je = new JAXBException(msg, linkedException);
        if (je.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + je.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.Throwable exception),
     * The detail message will default to null..
     * <br><b>Expected results</b>: the message is null
     */
    public Status Ctor013() {
        JAXBException je = new JAXBException(linkedException);
        if (je.getMessage() != null) {
            return Status.failed("getMessage() != null: \""
                               + je.getMessage() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor014() {
        JAXBException je = new JAXBException(linkedException);
        if (je.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + je.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public JAXBException(java.lang.Throwable exception),
     * Construct a JAXBException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor015() {
        JAXBException je = new JAXBException(linkedException);
        if (je.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + je.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.lang.String toString(),
     * <br><b>pre-conditions</b>: detail message, error code and linked exception are not null,
     * Returns a short description of this JAXBException..
     * <br><b>Expected output value</b>: non-empty string
     */
    public Status Ctor016() {
        JAXBException je = new JAXBException(msg, err, linkedException);
        String str = je.toString();

        if (str == null) {
            return Status.failed("je.toString() returns null");
        }

        if (str.length() <= 0) {
            return Status.failed("je.toString().length() returns " + str.length());
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and input values orientation
     * for public void setLinkedException(java.lang.Throwable exception),
     * <br><b>pre-conditions</b>: linkedException is not set,
     * <br><b>exception</b>: non-null.
     * <br><b>Expected results</b>: the linkedException is what set
     */
    public Status Ctor017() {
        JAXBException je = new JAXBException(msg);

        je.setLinkedException(linkedException);
        if (je.getLinkedException() == null) {
            return Status.failed("getLinkedException() == null");
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and input values orientation
     * for public void setLinkedException(java.lang.Throwable exception),
     * <br><b>pre-conditions</b>: linkedException is set to a non-null value,
     * <br><b>exception</b>: null.
     * <br><b>Expected results</b>: the linkedException is null
     */
    public Status Ctor018() {
        JAXBException je = new JAXBException(linkedException);

        je.setLinkedException(null);
        if (je.getLinkedException() != null) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + je.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void printStackTrace(java.io.PrintStream s),
     * <br><b>pre-conditions</b>: error message is set to a non-null value,
     * Prints this JAXBException and its stack trace to the PrintStream..
     * <br><b>Expected results</b>: at leat one byte has been written to the PrintWriter's stream
     */
    public Status Ctor021() {
        JAXBException je = new JAXBException(msg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);

        je.printStackTrace(ps);
        ps.close();
        if (baos.size() <= 0) {
            return Status.failed("no bytes were written to the stream");
        }

        return Status.passed("OKAY");
    }
}
