/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.TracingPropertySource;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.ui.launcher.TracingTab;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;

public class TracingBlock {
    private final TracingTab fTab;
    private Button fTracingCheck;
    private CheckboxTableViewer fPluginViewer;
    private IPluginModelBase[] fTraceableModels;
    private final Map<String, String> fMasterOptions = new HashMap<String, String>();
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fRestoreSelectedDefaultButton;
    private Button fRestoreDefaultButton;
    private final Map<IPluginModelBase, TracingPropertySource> fPropertySources = new HashMap<IPluginModelBase, TracingPropertySource>();
    private FormToolkit fToolkit;
    private ScrolledPageBook fPageBook;
    private static final String TRACING_SETTINGS = "TracingTab";
    private static final String SETTINGS_SELECTED_PLUGIN = "selectedPlugin";

    public TracingBlock(TracingTab tab) {
        this.fTab = tab;
    }

    public AbstractLauncherTab getTab() {
        return this.fTab;
    }

    public void createControl(Composite parent) {
        this.fTracingCheck = new Button(parent, 32);
        this.fTracingCheck.setText(PDEUIMessages.TracingLauncherTab_tracing);
        this.fTracingCheck.setLayoutData((Object)new GridData(768));
        this.fTracingCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection;
            this.masterCheckChanged();
            this.fTab.updateLaunchConfigurationDialog();
            if (this.fTracingCheck.getSelection() && !(selection = this.fPluginViewer.getStructuredSelection()).isEmpty()) {
                this.pluginSelected((IPluginModelBase)selection.getFirstElement(), this.fPluginViewer.getChecked(selection.getFirstElement()));
            }
        }));
        this.createSashSection(parent);
    }

    private void createSashSection(Composite container) {
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createPluginViewer((Composite)sashForm);
        this.createPropertySheetClient((Composite)sashForm);
    }

    private void createPluginViewer(Composite sashForm) {
        Composite composite = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        composite.setLayout((Layout)layout);
        this.fPluginViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.fPluginViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginViewer.setComparator((ViewerComparator)new ListUtil.PluginComparator());
        this.fPluginViewer.addSelectionChangedListener(e -> {
            this.fRestoreSelectedDefaultButton.setEnabled(true);
            CheckboxTableViewer tableViewer = (CheckboxTableViewer)e.getSource();
            boolean selected = tableViewer.getChecked((Object)this.getSelectedModel());
            this.pluginSelected(this.getSelectedModel(), selected);
            this.storeSelectedModel();
        });
        this.fPluginViewer.addCheckStateListener(event -> {
            CheckboxTableViewer tableViewer = (CheckboxTableViewer)event.getSource();
            tableViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
            this.pluginSelected(this.getSelectedModel(), event.getChecked());
            this.fTab.updateLaunchConfigurationDialog();
        });
        this.fPluginViewer.addDoubleClickListener(event -> {
            Object selection;
            CheckboxTableViewer tableViewer = (CheckboxTableViewer)event.getSource();
            boolean addingCheck = !tableViewer.getChecked(selection = ((IStructuredSelection)event.getSelection()).getFirstElement());
            tableViewer.setChecked(selection, addingCheck);
            this.pluginSelected(this.getSelectedModel(), addingCheck);
            this.fTab.updateLaunchConfigurationDialog();
        });
        GridData gd = new GridData(1808);
        gd.widthHint = 125;
        gd.heightHint = 100;
        this.fPluginViewer.getTable().setLayoutData((Object)gd);
        this.createButtonSection(composite);
    }

    private void createPropertySheetClient(Composite sashForm) {
        int margin;
        Composite tableChild = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableChild.setLayout((Layout)layout);
        layout.marginWidth = layout.marginHeight = (margin = this.createPropertySheet(tableChild));
    }

    private void createButtonSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.fSelectAllButton = new Button(container, 8);
        this.fSelectAllButton.setText(PDEUIMessages.TracingLauncherTab_enableAll);
        this.fSelectAllButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fSelectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fPluginViewer.setAllChecked(true);
            this.pluginSelected(this.getSelectedModel(), true);
            this.fTab.updateLaunchConfigurationDialog();
        }));
        this.fDeselectAllButton = new Button(container, 8);
        this.fDeselectAllButton.setText(PDEUIMessages.TracinglauncherTab_disableAll);
        this.fDeselectAllButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
        this.fDeselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fPluginViewer.setAllChecked(false);
            this.pluginSelected(this.getSelectedModel(), false);
            this.fTab.updateLaunchConfigurationDialog();
        }));
    }

    private void createRestoreButtonSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.fRestoreSelectedDefaultButton = new Button(container, 8);
        this.fRestoreSelectedDefaultButton.setText(PDEUIMessages.TracingBlock_restore_default_selected);
        this.fRestoreSelectedDefaultButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fRestoreSelectedDefaultButton);
        this.fRestoreSelectedDefaultButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selec = this.fPluginViewer.getStructuredSelection();
            Object object = selec.getFirstElement();
            if (object instanceof IPluginModelBase) {
                void model;
                IPluginModelBase iPluginModelBase = (IPluginModelBase)object;
                IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
                String modelName = model.getBundleDescription().getSymbolicName();
                if (modelName != null) {
                    Map properties = PDECore.getDefault().getTracingOptionsManager().getTracingTemplateCopy();
                    properties.forEach((arg_0, arg_1) -> this.lambda$7(modelName, (IPluginModelBase)model, arg_0, arg_1));
                    this.pluginSelected((IPluginModelBase)model, this.fPluginViewer.getChecked((Object)model));
                }
            }
        }));
        this.fRestoreDefaultButton = new Button(container, 8);
        this.fRestoreDefaultButton.setText(PDEUIMessages.TracingBlock_restore_default);
        this.fRestoreDefaultButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fRestoreDefaultButton);
        this.fRestoreDefaultButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object[] elements;
            this.disposePropertySources();
            this.fMasterOptions.clear();
            this.fMasterOptions.putAll(PDECore.getDefault().getTracingOptionsManager().getTracingTemplateCopy());
            Object[] objectArray = elements = this.fPluginViewer.getCheckedElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Object object = element;
                if (object instanceof IPluginModelBase) {
                    void model;
                    IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
                    IPluginModelBase cfr_ignored_1 = (IPluginModelBase)object;
                    TracingPropertySource source = this.getPropertySource((IPluginModelBase)model);
                    PageBookKey key = new PageBookKey((IPluginModelBase)model, true);
                    Composite parentPage = this.fPageBook.createPage((Object)key);
                    source.createContents(parentPage, true);
                    source.setChanged(false);
                }
                ++n2;
            }
            IStructuredSelection selec = this.fPluginViewer.getStructuredSelection();
            if (selec.getFirstElement() instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)this.fPluginViewer.getStructuredSelection().getFirstElement();
                this.pluginSelected(model, this.fPluginViewer.getChecked((Object)model));
            }
        }));
    }

    protected int createPropertySheet(Composite parent) {
        this.fToolkit = new FormToolkit(parent.getDisplay());
        int toolkitBorderStyle = this.fToolkit.getBorderStyle();
        int style = toolkitBorderStyle == 2048 ? 0 : 2048;
        Composite container = new Composite(parent, style);
        FillLayout flayout = new FillLayout();
        flayout.marginWidth = 1;
        flayout.marginHeight = 1;
        container.setLayout((Layout)flayout);
        container.setLayoutData((Object)new GridData(1808));
        this.fPageBook = new ScrolledPageBook(container, style | 0x200 | 0x100);
        this.fToolkit.adapt((Control)this.fPageBook, false, false);
        this.createRestoreButtonSection(parent);
        if (style == 0) {
            this.fPageBook.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.fToolkit.paintBordersFor(container);
        }
        return style == 0 ? 2 : 0;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fMasterOptions.clear();
        this.disposePropertySources();
        try {
            this.fTracingCheck.setSelection(config.getAttribute("tracing", false));
            Map options = config.getAttribute("tracingOptions", null);
            TracingOptionsManager mgr = PDECore.getDefault().getTracingOptionsManager();
            this.fMasterOptions.putAll(options == null ? mgr.getTracingTemplateCopy() : mgr.getTracingOptions(options));
            this.masterCheckChanged();
            String checked = config.getAttribute("checked", null);
            if (checked == null) {
                this.fPluginViewer.setAllChecked(true);
            } else if (checked.equals("[NONE]")) {
                this.fPluginViewer.setAllChecked(false);
            } else {
                List<IPluginModelBase> list = LaunchArgumentsHelper.splitElementsByComma((String)checked).map(PluginRegistry::findModel).filter(Objects::nonNull).toList();
                this.fPluginViewer.setCheckedElements(list.toArray());
                IPluginModelBase model = this.getLastSelectedPlugin();
                if (model == null && !list.isEmpty()) {
                    model = list.get(0);
                }
                if (model != null) {
                    this.fPluginViewer.setSelection((ISelection)new StructuredSelection((Object)model), true);
                    if (this.fTracingCheck.getSelection()) {
                        this.pluginSelected(model, list.contains(model));
                    }
                } else {
                    this.pluginSelected(null, false);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        Object[] checked;
        boolean tracingEnabled = this.fTracingCheck.getSelection();
        config.setAttribute("tracing", tracingEnabled);
        if (tracingEnabled) {
            boolean changes = false;
            for (TracingPropertySource source : this.fPropertySources.values()) {
                if (!source.isModified()) continue;
                changes = true;
                source.save();
            }
            if (changes) {
                HashMap atts = new HashMap(this.fMasterOptions.size());
                this.fMasterOptions.forEach((key, value) -> {
                    if (!key.startsWith("#")) {
                        atts.put(key, value);
                    }
                });
                config.setAttribute("tracingOptions", atts);
            }
        }
        if ((checked = this.fPluginViewer.getCheckedElements()).length == 0) {
            config.setAttribute("checked", "[NONE]");
        } else if (checked.length == this.fPluginViewer.getTable().getItemCount()) {
            config.setAttribute("checked", null);
        } else {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < checked.length) {
                IPluginModelBase model = (IPluginModelBase)checked[i];
                buffer.append(model.getPluginBase().getId());
                if (i < checked.length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            config.setAttribute("checked", buffer.toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("tracing", false);
        configuration.setAttribute("checked", "[NONE]");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fPageBook.getParent().getParent().layout(true);
    }

    public void dispose() {
        if (this.fToolkit != null) {
            this.fToolkit.dispose();
        }
    }

    public FormToolkit getToolkit() {
        return this.fToolkit;
    }

    /*
     * WARNING - void declaration
     */
    private IPluginModelBase getSelectedModel() {
        Object object;
        if (this.fTracingCheck.isEnabled() && (object = this.fPluginViewer.getStructuredSelection().getFirstElement()) instanceof IPluginModelBase) {
            void pluginModel;
            IPluginModelBase iPluginModelBase = (IPluginModelBase)object;
            IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
            return pluginModel;
        }
        return null;
    }

    private void pluginSelected(IPluginModelBase model, boolean checked) {
        TracingPropertySource source = this.getPropertySource(model);
        if (source == null) {
            this.fPageBook.showEmptyPage();
        } else {
            PageBookKey key = new PageBookKey(model, checked);
            if (!this.fPageBook.hasPage((Object)key) || source.isChanged()) {
                Composite parent = this.fPageBook.createPage((Object)key);
                source.createContents(parent, checked);
                source.setChanged(false);
            }
            this.fPageBook.showPage((Object)key);
        }
    }

    private IPluginModelBase[] getTraceableModels() {
        if (this.fTraceableModels == null) {
            IPluginModelBase[] models = PluginRegistry.getActiveModels();
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            IPluginModelBase[] iPluginModelBaseArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (TracingOptionsManager.isTraceable((IPluginModelBase)model)) {
                    result.add(model);
                }
                ++n2;
            }
            this.fTraceableModels = result.toArray(new IPluginModelBase[result.size()]);
        }
        return this.fTraceableModels;
    }

    private IPluginModelBase getLastSelectedPlugin() {
        String id;
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(TRACING_SETTINGS);
        if (settings != null && (id = settings.get(SETTINGS_SELECTED_PLUGIN)) != null && id.trim().length() > 0) {
            return PluginRegistry.findModel((String)id);
        }
        return null;
    }

    private void storeSelectedModel() {
        IPluginModelBase model;
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(TRACING_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(TRACING_SETTINGS);
        }
        if ((model = this.getSelectedModel()) != null && this.fPluginViewer.getChecked((Object)model)) {
            settings.put(SETTINGS_SELECTED_PLUGIN, model.getPluginBase().getId());
        } else {
            settings.put(SETTINGS_SELECTED_PLUGIN, null);
        }
    }

    private TracingPropertySource getPropertySource(IPluginModelBase model) {
        if (model == null) {
            return null;
        }
        return this.fPropertySources.computeIfAbsent(model, m -> {
            String id = m.getPluginBase().getId();
            Map defaults = PDECore.getDefault().getTracingOptionsManager().getTemplateTable(id);
            TracingPropertySource source = new TracingPropertySource((IPluginModelBase)m, this.fMasterOptions, defaults, this);
            source.setChanged(true);
            return source;
        });
    }

    private void masterCheckChanged() {
        boolean enabled = this.fTracingCheck.getSelection();
        this.fPluginViewer.getTable().setEnabled(enabled);
        Control currentPage = this.fPageBook.getCurrentPage();
        if (currentPage != null && !enabled) {
            this.fPageBook.showEmptyPage();
        }
        if (enabled) {
            this.fPluginViewer.setInput((Object)this.getTraceableModels());
        }
        int count = 0;
        if (this.fPluginViewer != null) {
            count = this.fPluginViewer.getTable().getItemCount();
        }
        this.fSelectAllButton.setEnabled(enabled && count > 0);
        this.fDeselectAllButton.setEnabled(enabled && count > 0);
        this.fRestoreDefaultButton.setEnabled(enabled && count > 0);
        this.fRestoreSelectedDefaultButton.setEnabled(!this.fPluginViewer.getStructuredSelection().isEmpty());
        if (!enabled) {
            this.fRestoreSelectedDefaultButton.setEnabled(false);
        }
    }

    private void disposePropertySources() {
        for (TracingPropertySource source : this.fPropertySources.values()) {
            this.fPageBook.removePage((Object)source.getModel());
        }
        this.fPropertySources.clear();
    }

    private /* synthetic */ void lambda$7(String string, IPluginModelBase iPluginModelBase, String key, String value) {
        if (key.startsWith(string + "/")) {
            this.fMasterOptions.put(key, value);
            TracingPropertySource source = this.getPropertySource(iPluginModelBase);
            source.setChanged(true);
        }
    }

    private record PageBookKey(IPluginModelBase fModel, boolean fEnabled) {
    }
}

