/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.nls.ModelChangeElement;
import org.eclipse.pde.internal.ui.nls.ModelChangeFile;

public class ModelChange {
    private static final String DEFAULT_LOCALIZATION_PREFIX = "plugin";
    public static final String LOCALIZATION_FILE_SUFFIX = ".properties";
    private ModelChangeFile fXMLCoupling;
    private ModelChangeFile fMFCoupling;
    private final IPluginModelBase fParent;
    private final boolean fPreSelected;
    private String fBundleLocalization;
    private Properties fProperties;
    private boolean fReloadProperties = true;

    protected static boolean modelLoaded(IModel model) {
        try {
            model.load();
        }
        catch (CoreException coreException) {}
        return model.isLoaded();
    }

    public ModelChange(IPluginModelBase parent, boolean preSelected) {
        this.fParent = parent;
        this.fPreSelected = preSelected;
        this.fBundleLocalization = PDEManager.getBundleLocalization((IPluginModelBase)this.fParent);
        if (this.fBundleLocalization == null) {
            this.fBundleLocalization = DEFAULT_LOCALIZATION_PREFIX;
        }
    }

    public void addChange(IFile file, ModelChangeElement change) {
        if (change == null || file == null) {
            return;
        }
        String ext = file.getFileExtension();
        if (ext.equalsIgnoreCase("xml")) {
            this.addXMLChange(file, change);
        } else if (ext.equalsIgnoreCase("MF")) {
            this.addMFChange(file, change);
        } else {
            return;
        }
    }

    private void addXMLChange(IFile file, ModelChangeElement change) {
        if (this.fXMLCoupling == null) {
            this.fXMLCoupling = new ModelChangeFile(file, this);
        }
        if (!this.fXMLCoupling.getFile().equals((Object)file)) {
            return;
        }
        this.fXMLCoupling.add(change);
    }

    private void addMFChange(IFile file, ModelChangeElement change) {
        if (this.fMFCoupling == null) {
            this.fMFCoupling = new ModelChangeFile(file, this);
        }
        this.fMFCoupling.add(change);
    }

    public IFile[] getChangeFiles() {
        IFile mfFile;
        IFile xmlFile = this.fXMLCoupling != null ? this.fXMLCoupling.getFile() : null;
        IFile iFile = mfFile = this.fMFCoupling != null ? this.fMFCoupling.getFile() : null;
        if (xmlFile != null && mfFile != null) {
            return new IFile[]{xmlFile, mfFile};
        }
        if (xmlFile != null) {
            return new IFile[]{xmlFile};
        }
        if (mfFile != null) {
            return new IFile[]{mfFile};
        }
        return new IFile[0];
    }

    public IFile getPropertiesFile() {
        return PDEProject.getLocalizationFile((IProject)this.fParent.getUnderlyingResource().getProject());
    }

    public Properties getProperties() {
        if (this.fProperties == null || this.fReloadProperties) {
            this.fProperties = new Properties();
            IFile propertiesFile = this.getPropertiesFile();
            if (propertiesFile != null && propertiesFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (InputStream stream = propertiesFile.getContents();){
                        this.fProperties.load(stream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException throwable) {}
            }
            this.fReloadProperties = false;
        }
        return this.fProperties;
    }

    public ArrayList<?> getChangesInFile(IFile file) {
        if (this.fXMLCoupling != null && file == this.fXMLCoupling.getFile()) {
            return this.fXMLCoupling.getChanges();
        }
        if (this.fMFCoupling != null && file == this.fMFCoupling.getFile()) {
            return this.fMFCoupling.getChanges();
        }
        return null;
    }

    public int getNumberOfChangesInFile(IFile file) {
        if (this.fXMLCoupling != null && file == this.fXMLCoupling.getFile()) {
            return this.fXMLCoupling.getNumChanges();
        }
        if (this.fMFCoupling != null && file == this.fMFCoupling.getFile()) {
            return this.fMFCoupling.getNumChanges();
        }
        return 0;
    }

    public boolean wasPreSelected() {
        return this.fPreSelected;
    }

    public IPluginModelBase getParentModel() {
        return this.fParent;
    }

    public ModelChangeFile[] getModelChangeFiles() {
        if (this.fXMLCoupling != null && this.fMFCoupling != null) {
            return new ModelChangeFile[]{this.fXMLCoupling, this.fMFCoupling};
        }
        if (this.fXMLCoupling != null) {
            return new ModelChangeFile[]{this.fXMLCoupling};
        }
        if (this.fMFCoupling != null) {
            return new ModelChangeFile[]{this.fMFCoupling};
        }
        return new ModelChangeFile[0];
    }

    public void setBundleLocalization(String bundleLocalization) {
        if (bundleLocalization == null || bundleLocalization.endsWith(LOCALIZATION_FILE_SUFFIX)) {
            throw new IllegalArgumentException();
        }
        if (bundleLocalization.equals(this.fBundleLocalization)) {
            return;
        }
        this.fBundleLocalization = bundleLocalization;
        this.fReloadProperties = true;
    }

    public String getBundleLocalization() {
        return this.fBundleLocalization;
    }

    public boolean localizationSet() {
        String localization = PDEManager.getBundleLocalization((IPluginModelBase)this.fParent);
        return localization != null && localization.length() > 0;
    }
}

