/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.frontend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.application.Platform;
import org.eclipse.fx.drift.DriftFXSurface;
import org.eclipse.fx.drift.PresentationMode;
import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.frontend.FrontSwapChain;
import org.eclipse.fx.drift.internal.frontend.Frontend;
import org.eclipse.fx.drift.internal.frontend.SimpleFrontSwapChain;
import org.eclipse.fx.drift.internal.transport.Command;
import org.eclipse.fx.drift.internal.transport.command.CreateSwapchainCommand;
import org.eclipse.fx.drift.internal.transport.command.DisposeSwapchainCommand;
import org.eclipse.fx.drift.internal.transport.command.PresentCommand;
import org.eclipse.fx.drift.internal.transport.command.ReleaseCommand;

public class FrontendImpl
implements Frontend {
    private static final DriftLogger LOGGER = DriftFX.createLogger(FrontendImpl.class);
    private DriftFXSurface surface;
    private FrontSwapChain swapChain;
    private Map<UUID, FrontSwapChain> swapChains = new HashMap<UUID, FrontSwapChain>();
    private Consumer<Command> commandChannel;

    public FrontendImpl(DriftFXSurface surface) {
        this.surface = surface;
    }

    @Override
    public Vec2i getSize() {
        double w = this.surface.getWidth();
        double h = this.surface.getHeight();
        double userScale = this.surface.getUserScaleFactor();
        double screenScale = this.surface.getScreenScaleFactor();
        int x = (int)Math.ceil(w * userScale * screenScale);
        int y = (int)Math.ceil(h * userScale * screenScale);
        return new Vec2i(x, y);
    }

    public void doCreateSwapchain(UUID id, List<ImageData> images, PresentationMode presentationMode) {
        this.swapChain = new SimpleFrontSwapChain(id, images, presentationMode, this::sendRelease);
        this.swapChains.put(id, this.swapChain);
        this.surface.setSwapChain(this.swapChain);
    }

    public void doDisposeSwapchain(UUID id) {
        this.swapChains.get(id).scheduleDispose();
        Platform.runLater(this.surface::dirty);
    }

    public void doPresent(ImageData image) {
        this.swapChain.present(image);
        this.surface.dirty();
    }

    private void sendRelease(UUID id, ImageData image) {
        this.commandChannel.accept(new ReleaseCommand(id, image));
    }

    @Override
    public void setCommandChannel(Consumer<Command> commandChannel) {
        this.commandChannel = commandChannel;
    }

    @Override
    public void receiveCommand(Command command) {
        if (command instanceof CreateSwapchainCommand) {
            LOGGER.debug(() -> "Frontend received " + command);
            CreateSwapchainCommand cmd = (CreateSwapchainCommand)command;
            this.doCreateSwapchain(cmd.getId(), cmd.getImages(), cmd.getPresentatioMode());
        } else if (command instanceof PresentCommand) {
            PresentCommand cmd = (PresentCommand)command;
            if (cmd.getSwapChainId().equals(this.swapChain.getId())) {
                this.doPresent(cmd.getImageData());
            } else {
                LOGGER.debug(() -> "!!! Instant release");
                this.sendRelease(cmd.getSwapChainId(), cmd.getImageData());
            }
        } else if (command instanceof DisposeSwapchainCommand) {
            LOGGER.debug(() -> "Frontend received " + command);
            DisposeSwapchainCommand cmd = (DisposeSwapchainCommand)command;
            this.doDisposeSwapchain(cmd.getId());
        }
    }
}

