/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.List;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.impl.XClosureImplCustom;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IClosureCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.computation.ResolvingTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractClosureTypeHelper
implements IClosureCandidate {
    private final XClosure closure;
    private final ITypeComputationState state;
    private final CommonTypeComputationServices services;
    private final ITypeExpectation expectation;

    protected AbstractClosureTypeHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        this.closure = closure;
        this.expectation = expectation;
        this.state = state;
        this.services = state.getReferenceOwner().getServices();
    }

    protected ITypeComputationState getState() {
        return this.state;
    }

    protected ITypeExpectation getExpectation() {
        return this.expectation;
    }

    protected XClosure getClosure() {
        return this.closure;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected abstract void computeTypes();

    public abstract FunctionTypeReference getExpectedClosureType();

    public abstract JvmOperation getOperation();

    protected void deferredBindTypeArgument(LightweightTypeReference declared, LightweightTypeReference actual, final BoundTypeArgumentSource source) {
        if (declared != null) {
            ResolvingTypeParameterHintCollector collector = new ResolvingTypeParameterHintCollector(this.expectation.getReferenceOwner(), source){

                @Override
                protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                    LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                    if (source == BoundTypeArgumentSource.INFERRED_CONSTRAINT) {
                        wrapped = this.getStricterConstraint(typeParameter, wrapped);
                    }
                    typeParameter.acceptHint(wrapped, source, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                }
            };
            collector.processPairedReferences(declared, actual);
        }
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        if (!this.closure.isExplicitSyntax()) {
            List<JvmFormalParameter> parametersToAdd = this.getParameters();
            InternalEList targetList = (InternalEList)this.closure.getImplicitFormalParameters();
            if (!targetList.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < parametersToAdd.size()) {
                JvmFormalParameter parameter = parametersToAdd.get(i);
                LightweightTypeReference parameterType = resolvedTypes.getActualType((JvmIdentifiableElement)parameter);
                if (parameterType == null) {
                    throw new IllegalStateException("Cannot find type for parameter " + parameter.getSimpleName());
                }
                JvmTypeReference typeReference = parameterType.toTypeReference();
                parameter.setParameterType(typeReference);
                targetList.addUnique((Object)parameter);
                ++i;
            }
        }
        ((XClosureImplCustom)this.closure).setLinked(true);
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        return true;
    }

    @Override
    public abstract List<JvmFormalParameter> getParameters();
}

