/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class STRINGValueConverter
extends AbstractLexerBasedConverter<String> {
    @Override
    protected String toEscapedString(String value) {
        return '\"' + Strings.convertToJavaString((String)value, (boolean)false) + '\"';
    }

    @Override
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() == 1) {
                throw new ValueConverterWithValueException(this.getStringNotClosedMessage(), node, "", null);
            }
            return this.convertFromString(string, node);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, e);
        }
    }

    protected String convertFromString(String literal, INode node) throws ValueConverterWithValueException {
        int length = literal.length();
        StringBuilder result = new StringBuilder(length);
        ErrorInfo errorInfo = new ErrorInfo();
        int nextIndex = 1;
        while (nextIndex < length - 1) {
            nextIndex = this.unescapeCharAndAppendTo(literal, nextIndex, result, errorInfo);
        }
        if (nextIndex < length) {
            if (nextIndex != length - 1) {
                throw new IllegalStateException();
            }
            char next = literal.charAt(nextIndex);
            if (literal.charAt(0) != next) {
                result.append(next);
                if (errorInfo.errorMessage == null) {
                    if (next == '\\') {
                        errorInfo.errorMessage = this.getInvalidEscapeSequenceMessage();
                        errorInfo.errorIndex = nextIndex;
                        errorInfo.errorLength = 1;
                    } else {
                        errorInfo.errorMessage = this.getStringNotClosedMessage();
                    }
                } else {
                    errorInfo.errorMessage = this.getStringNotClosedMessage();
                    errorInfo.errorIndex = -1;
                    errorInfo.errorLength = -1;
                }
            }
        } else if (nextIndex == length) {
            errorInfo.errorMessage = this.getStringNotClosedMessage();
        }
        if (errorInfo.errorMessage != null) {
            throw new ValueConverterWithValueException(errorInfo.errorMessage, node, result.toString(), errorInfo.errorIndex, errorInfo.errorLength, null);
        }
        return result.toString();
    }

    protected String getInvalidEscapeSequenceMessage() {
        return "Invalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )";
    }

    protected String getStringNotClosedMessage() {
        return "String literal is not properly closed";
    }

    private int unescapeCharAndAppendTo(String string, int index, StringBuilder result, ErrorInfo errorInfo) {
        char c;
        if ((c = string.charAt(index++)) == '\\') {
            index = this.doUnescapeCharAndAppendTo(string, index, result, errorInfo);
        } else {
            result.append(c);
        }
        return index;
    }

    private int doUnescapeCharAndAppendTo(String string, int index, StringBuilder result, ErrorInfo errorInfo) {
        if (string.length() == index) {
            if (errorInfo.errorMessage == null) {
                errorInfo.errorMessage = this.getInvalidEscapeSequenceMessage();
                errorInfo.errorIndex = index - 1;
                errorInfo.errorLength = 1;
            }
            return index;
        }
        char c = string.charAt(index++);
        switch (c) {
            case 'b': {
                c = '\b';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case '\"': 
            case '\'': 
            case '\\': {
                break;
            }
            case 'u': {
                return this.unescapeUnicodeSequence(string, index, result, errorInfo);
            }
            default: {
                if (errorInfo.errorMessage != null) break;
                errorInfo.errorMessage = this.getInvalidEscapeSequenceMessage();
                errorInfo.errorIndex = index - 2;
                errorInfo.errorLength = 2;
            }
        }
        result.append(c);
        return index;
    }

    private int unescapeUnicodeSequence(String string, int index, StringBuilder result, ErrorInfo errorInfo) {
        try {
            if (index + 4 > string.length() || !this.isHexSequence(string, index, 4)) {
                result.append('u');
                errorInfo.errorMessage = "Invalid unicode";
                errorInfo.errorIndex = index - 2;
                errorInfo.errorLength = 2;
                return index;
            }
            result.append((char)Integer.parseInt(string.substring(index, index + 4), 16));
            return index + 4;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal \\uxxxx encoding in " + string);
        }
    }

    private boolean isHexSequence(String in, int off, int chars) {
        block3: for (int i = off; i < in.length() && i < off + chars; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isHexSequence(char[] in, int off, int chars) {
        block3: for (int i = off; i < in.length && i < off + chars; ++i) {
            char c = in[i];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static class ErrorInfo {
        String errorMessage = null;
        int errorIndex = -1;
        int errorLength = -1;

        private ErrorInfo() {
        }
    }
}

