/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import java.lang.reflect.Type;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AuthentificationRequired;
import org.eclipse.egerrit.internal.core.command.BaseCommandChangeAndRevision;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.MergeableInfo;

public class GetMergeableCommand
extends BaseCommandChangeAndRevision<MergeableInfo> {
    private ChangeInfo changeInfo;

    public GetMergeableCommand(GerritRepository gerritRepository, ChangeInfo changeInfo, String revisionId) {
        super(gerritRepository, AuthentificationRequired.NO, (Class<? extends HttpRequestBase>)HttpGet.class, (Type)((Object)MergeableInfo.class), changeInfo.getId(), revisionId == null ? "current" : revisionId);
        this.changeInfo = changeInfo;
        this.setPathFormat("/changes/{change-id}/revisions/{revision-id}/mergeable");
    }

    @Override
    protected boolean handleHttpException(ClientProtocolException e) throws EGerritException {
        HttpResponseException httpException = (HttpResponseException)((Object)e);
        if (httpException.getStatusCode() != 409 || !this.changeInfo.getStatus().toUpperCase().equals("SUBMITTED")) {
            throw new EGerritException(e.getLocalizedMessage());
        }
        return true;
    }
}

