/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerEdgeTwoNodeCrossingsCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.SwitchDecider;
import org.eclipse.elk.alg.layered.properties.GreedySwitchType;

public class CrossingMatrixFiller {
    private final boolean[][] isCrossingMatrixFilled;
    private final int[][] crossingMatrix;
    private final BetweenLayerEdgeTwoNodeCrossingsCounter inBetweenLayerCrossingCounter;
    private final SwitchDecider.CrossingCountSide direction;
    private final boolean oneSided;

    public CrossingMatrixFiller(GreedySwitchType greedyType, LNode[][] graph, int freeLayerIndex, SwitchDecider.CrossingCountSide direction) {
        this.direction = direction;
        this.oneSided = greedyType.isOneSided();
        LNode[] freeLayer = graph[freeLayerIndex];
        this.isCrossingMatrixFilled = new boolean[freeLayer.length][freeLayer.length];
        this.crossingMatrix = new int[freeLayer.length][freeLayer.length];
        this.inBetweenLayerCrossingCounter = new BetweenLayerEdgeTwoNodeCrossingsCounter(graph, freeLayerIndex);
    }

    public int getCrossingMatrixEntry(LNode upperNode, LNode lowerNode) {
        if (!this.isCrossingMatrixFilled[upperNode.id][lowerNode.id]) {
            this.fillCrossingMatrix(upperNode, lowerNode);
            this.isCrossingMatrixFilled[upperNode.id][lowerNode.id] = true;
            this.isCrossingMatrixFilled[lowerNode.id][upperNode.id] = true;
        }
        return this.crossingMatrix[upperNode.id][lowerNode.id];
    }

    private void fillCrossingMatrix(LNode upperNode, LNode lowerNode) {
        if (this.oneSided) {
            switch (this.direction) {
                case EAST: {
                    this.inBetweenLayerCrossingCounter.countEasternEdgeCrossings(upperNode, lowerNode);
                    break;
                }
                case WEST: {
                    this.inBetweenLayerCrossingCounter.countWesternEdgeCrossings(upperNode, lowerNode);
                }
            }
        } else {
            this.inBetweenLayerCrossingCounter.countBothSideCrossings(upperNode, lowerNode);
        }
        this.crossingMatrix[upperNode.id][lowerNode.id] = this.inBetweenLayerCrossingCounter.getUpperLowerCrossings();
        this.crossingMatrix[lowerNode.id][upperNode.id] = this.inBetweenLayerCrossingCounter.getLowerUpperCrossings();
    }
}

