/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order.counting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.p3order.counting.AbstractCrossingsCounter;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class HyperedgeCrossingsCounter
extends AbstractCrossingsCounter {
    private final int[] portPos;

    public HyperedgeCrossingsCounter(int[] inLayerEdgeCount, boolean[] hasNorthSouthPorts, int[] portPos) {
        super(inLayerEdgeCount, hasNorthSouthPorts);
        this.portPos = portPos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int countCrossings(LNode[] leftLayer, LNode[] rightLayer) {
        void var14_78;
        void var14_77;
        int n;
        void var14_75;
        void var13_66;
        void var12_54;
        void var11_41;
        int sourceCount = 0;
        LNode[] lNodeArray = leftLayer;
        int n2 = leftLayer.length;
        int n22 = 0;
        while (n22 < n2) {
            LNode node = lNodeArray[n22];
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port : node.getPorts()) {
                    int portEdges = 0;
                    for (LEdge lEdge : port.getOutgoingEdges()) {
                        if (node.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    this.portPos[port.id] = sourceCount++;
                }
            } else {
                int nodeEdges232 = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getOutgoingEdges()) {
                        if (node.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                        ++nodeEdges232;
                    }
                    this.portPos[port.id] = sourceCount;
                }
                if (nodeEdges232 > 0) {
                    ++sourceCount;
                }
            }
            ++n22;
        }
        int targetCount = 0;
        LNode[] nodeEdges232 = rightLayer;
        int n3 = rightLayer.length;
        n2 = 0;
        while (n2 < n3) {
            LNode node = nodeEdges232[n2];
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block14: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++northInputPorts;
                        continue block14;
                    }
                }
                int otherInputPorts = 0;
                ListIterator<LPort> listIterator = node.getPorts().listIterator(node.getPorts().size());
                while (listIterator.hasPrevious()) {
                    void var13_60;
                    LPort lPort = listIterator.previous();
                    boolean bl = false;
                    for (LEdge lEdge : lPort.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++var13_60;
                    }
                    if (var13_60 <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.portPos[lPort.id] = targetCount++;
                        continue;
                    }
                    this.portPos[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                    ++otherInputPorts;
                }
                targetCount += otherInputPorts;
            } else {
                int nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++nodeEdges;
                    }
                    this.portPos[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                }
            }
            ++n2;
        }
        HashMap port2HyperedgeMap = Maps.newHashMap();
        LinkedHashSet hyperedgeSet = Sets.newLinkedHashSet();
        LNode[] port = leftLayer;
        int nodeEdges = leftLayer.length;
        int nodeEdges232 = 0;
        while (nodeEdges232 < nodeEdges) {
            LNode node = port[nodeEdges232];
            for (LPort lPort : node.getPorts()) {
                for (LEdge lEdge : lPort.getOutgoingEdges()) {
                    LPort targetPort = lEdge.getTarget();
                    if (node.getLayer() == targetPort.getNode().getLayer()) continue;
                    Hyperedge sourceHE = (Hyperedge)port2HyperedgeMap.get((Object)lPort);
                    Hyperedge targetHE = (Hyperedge)port2HyperedgeMap.get((Object)targetPort);
                    if (sourceHE == null && targetHE == null) {
                        Hyperedge hyperedge = new Hyperedge();
                        hyperedgeSet.add(hyperedge);
                        hyperedge.edges.add(lEdge);
                        hyperedge.ports.add(lPort);
                        port2HyperedgeMap.put(lPort, hyperedge);
                        hyperedge.ports.add(targetPort);
                        port2HyperedgeMap.put(targetPort, hyperedge);
                        continue;
                    }
                    if (sourceHE == null) {
                        targetHE.edges.add(lEdge);
                        targetHE.ports.add(lPort);
                        port2HyperedgeMap.put(lPort, targetHE);
                        continue;
                    }
                    if (targetHE == null) {
                        sourceHE.edges.add(lEdge);
                        sourceHE.ports.add(targetPort);
                        port2HyperedgeMap.put(targetPort, sourceHE);
                        continue;
                    }
                    if (sourceHE == targetHE) {
                        sourceHE.edges.add(lEdge);
                        continue;
                    }
                    sourceHE.edges.add(lEdge);
                    for (LPort p : targetHE.ports) {
                        port2HyperedgeMap.put(p, sourceHE);
                    }
                    sourceHE.edges.addAll(targetHE.edges);
                    sourceHE.ports.addAll(targetHE.ports);
                    hyperedgeSet.remove(targetHE);
                }
            }
            ++nodeEdges232;
        }
        Object[] hyperedges = hyperedgeSet.toArray(new Hyperedge[hyperedgeSet.size()]);
        Layer leftLayerRef = leftLayer[0].getLayer();
        Layer rightLayerRef = rightLayer[0].getLayer();
        Object[] objectArray = hyperedges;
        int n4 = hyperedges.length;
        boolean bl = false;
        while (var11_41 < n4) {
            Object he = objectArray[var11_41];
            ((Hyperedge)he).upperLeft = sourceCount;
            ((Hyperedge)he).upperRight = targetCount;
            for (LPort lPort : ((Hyperedge)he).ports) {
                int pos = this.portPos[lPort.id];
                if (lPort.getNode().getLayer() == leftLayerRef) {
                    if (pos < ((Hyperedge)he).upperLeft) {
                        ((Hyperedge)he).upperLeft = pos;
                    }
                    if (pos <= ((Hyperedge)he).lowerLeft) continue;
                    ((Hyperedge)he).lowerLeft = pos;
                    continue;
                }
                if (lPort.getNode().getLayer() != rightLayerRef) continue;
                if (pos < ((Hyperedge)he).upperRight) {
                    ((Hyperedge)he).upperRight = pos;
                }
                if (pos <= ((Hyperedge)he).lowerRight) continue;
                ((Hyperedge)he).lowerRight = pos;
            }
            ++var11_41;
        }
        Arrays.sort(hyperedges);
        int[] southSequence = new int[hyperedges.length];
        int[] nArray = new int[targetCount + 1];
        boolean bl2 = false;
        while (var12_54 < hyperedges.length) {
            southSequence[var12_54] = ((Hyperedge)hyperedges[var12_54]).upperRight;
            nArray[southSequence[var12_54]] = 1;
            ++var12_54;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        while (var13_66 < nArray.length) {
            void var12_56;
            if (nArray[var13_66] == 1) {
                nArray[var13_66] = var12_56;
            } else {
                --var12_56;
            }
            ++var13_66;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        while (var14_75 < southSequence.length) {
            void v0 = var14_75;
            southSequence[v0] = southSequence[v0] + nArray[southSequence[var14_75]];
            n = Math.max(n, southSequence[var14_75] + 1);
            ++var14_75;
        }
        boolean bl7 = true;
        while (var14_77 < n) {
            var14_77 *= 2;
        }
        int treeSize = 2 * var14_77 - 1;
        --var14_78;
        int[] tree = new int[treeSize];
        int crossings = 0;
        int k = 0;
        while (k < southSequence.length) {
            int index;
            int n5 = index = southSequence[k] + var14_78;
            tree[n5] = tree[n5] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossings += tree[index + 1];
                }
                int n6 = index = (index - 1) / 2;
                tree[n6] = tree[n6] + 1;
            }
            ++k;
        }
        Object[] leftCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i4 = 0;
        while (i4 < hyperedges.length) {
            leftCorners[2 * i4] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).upperLeft, ((Hyperedge)hyperedges[i4]).lowerLeft, HyperedgeCorner.Type.UPPER);
            leftCorners[2 * i4 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).lowerLeft, ((Hyperedge)hyperedges[i4]).upperLeft, HyperedgeCorner.Type.LOWER);
            ++i4;
        }
        Arrays.sort(leftCorners);
        int openHyperedges = 0;
        int i5 = 0;
        while (i5 < leftCorners.length) {
            switch (((HyperedgeCorner)leftCorners[i5]).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++i5;
        }
        Object[] rightCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i6 = 0;
        while (i6 < hyperedges.length) {
            rightCorners[2 * i6] = new HyperedgeCorner((Hyperedge)hyperedges[i6], ((Hyperedge)hyperedges[i6]).upperRight, ((Hyperedge)hyperedges[i6]).lowerRight, HyperedgeCorner.Type.UPPER);
            rightCorners[2 * i6 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i6], ((Hyperedge)hyperedges[i6]).lowerRight, ((Hyperedge)hyperedges[i6]).upperRight, HyperedgeCorner.Type.LOWER);
            ++i6;
        }
        Arrays.sort(rightCorners);
        openHyperedges = 0;
        int i = 0;
        while (i < rightCorners.length) {
            switch (((HyperedgeCorner)rightCorners[i]).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++i;
        }
        return crossings;
    }

    private static class Hyperedge
    implements Comparable<Hyperedge> {
        private List<LEdge> edges = Lists.newArrayList();
        private List<LPort> ports = Lists.newArrayList();
        private int upperLeft;
        private int lowerLeft;
        private int upperRight;
        private int lowerRight;

        private Hyperedge() {
        }

        @Override
        public int compareTo(Hyperedge other) {
            if (this.upperLeft < other.upperLeft) {
                return -1;
            }
            if (this.upperLeft > other.upperLeft) {
                return 1;
            }
            if (this.upperRight < other.upperRight) {
                return -1;
            }
            if (this.upperRight > other.upperRight) {
                return 1;
            }
            return this.hashCode() - other.hashCode();
        }
    }

    private static class HyperedgeCorner
    implements Comparable<HyperedgeCorner> {
        private Hyperedge hyperedge;
        private int position;
        private int oppositePosition;
        private Type type;

        HyperedgeCorner(Hyperedge hyperedge, int position, int oppositePosition, Type type) {
            this.hyperedge = hyperedge;
            this.position = position;
            this.oppositePosition = oppositePosition;
            this.type = type;
        }

        @Override
        public int compareTo(HyperedgeCorner other) {
            if (this.position < other.position) {
                return -1;
            }
            if (this.position > other.position) {
                return 1;
            }
            if (this.oppositePosition < other.oppositePosition) {
                return -1;
            }
            if (this.oppositePosition > other.oppositePosition) {
                return 1;
            }
            if (this.hyperedge != other.hyperedge) {
                return this.hyperedge.hashCode() - other.hyperedge.hashCode();
            }
            if (this.type == Type.UPPER && other.type == Type.LOWER) {
                return -1;
            }
            if (this.type == Type.LOWER && other.type == Type.UPPER) {
                return 1;
            }
            return 0;
        }

        static enum Type {
            UPPER,
            LOWER;

        }
    }
}

