/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes;

import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.Spacings;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InteractiveNodePlacer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private Spacings spacings;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive node placement", 1.0f);
        this.spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        for (Layer layer : layeredGraph) {
            this.placeNodes(layer);
        }
        monitor.done();
    }

    private void placeNodes(Layer layer) {
        double minValidY = Double.NEGATIVE_INFINITY;
        LNode.NodeType prevNodeType = LNode.NodeType.NORMAL;
        for (LNode node : layer) {
            float spacing;
            LNode.NodeType nodeType = node.getType();
            if (nodeType != LNode.NodeType.NORMAL) {
                Double originalYCoordinate = (Double)node.getProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION);
                if (originalYCoordinate == null) {
                    minValidY = Math.max(minValidY, 0.0);
                    node.getPosition().y = minValidY + (double)this.spacings.getVerticalSpacing(nodeType, prevNodeType);
                } else {
                    node.getPosition().y = originalYCoordinate;
                }
            }
            if (node.getPosition().y < minValidY + (double)(spacing = this.spacings.getVerticalSpacing(nodeType, prevNodeType)) + node.getMargin().top) {
                node.getPosition().y = minValidY + (double)spacing + node.getMargin().top;
            }
            minValidY = node.getPosition().y + node.getSize().y + node.getMargin().bottom;
            prevNodeType = nodeType;
        }
    }
}

