/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.KNode;

public class BoxLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "org.eclipse.elk.alg.box";
    private static final float DEF_SPACING = 15.0f;
    public static final float DEF_ASPECT_RATIO = 1.3f;

    @Override
    public void layout(KNode layoutNode, IElkProgressMonitor progressMonitor) {
        Float borderSpacing;
        progressMonitor.begin("Box layout", 2.0f);
        KShapeLayout parentLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        Float objSpacing = (Float)parentLayout.getProperty(CoreOptions.SPACING_NODE);
        if (objSpacing == null || objSpacing.floatValue() < 0.0f) {
            objSpacing = Float.valueOf(15.0f);
        }
        if ((borderSpacing = (Float)parentLayout.getProperty(CoreOptions.SPACING_BORDER)) == null || borderSpacing.floatValue() < 0.0f) {
            borderSpacing = Float.valueOf(15.0f);
        }
        boolean expandNodes = (Boolean)parentLayout.getProperty(CoreOptions.EXPAND_NODES);
        boolean interactive = (Boolean)parentLayout.getProperty(CoreOptions.INTERACTIVE);
        List<KNode> sortedBoxes = this.sort(layoutNode, interactive);
        this.placeBoxes(sortedBoxes, layoutNode, objSpacing.floatValue(), borderSpacing.floatValue(), expandNodes);
        progressMonitor.done();
    }

    private List<KNode> sort(KNode parentNode, final boolean interactive) {
        LinkedList<KNode> sortedBoxes = new LinkedList<KNode>((Collection<KNode>)parentNode.getChildren());
        Collections.sort(sortedBoxes, new Comparator<KNode>(){

            @Override
            public int compare(KNode child1, KNode child2) {
                KShapeLayout layout2;
                Integer prio2;
                KShapeLayout layout1 = (KShapeLayout)child1.getData(KShapeLayout.class);
                Integer prio1 = (Integer)layout1.getProperty(CoreOptions.PRIORITY);
                if (prio1 == null) {
                    prio1 = 0;
                }
                if ((prio2 = (Integer)(layout2 = (KShapeLayout)child2.getData(KShapeLayout.class)).getProperty(CoreOptions.PRIORITY)) == null) {
                    prio2 = 0;
                }
                if (prio1 > prio2) {
                    return -1;
                }
                if (prio1 < prio2) {
                    return 1;
                }
                if (interactive) {
                    int c = Float.compare(layout1.getYpos(), layout2.getYpos());
                    if (c != 0) {
                        return c;
                    }
                    c = Float.compare(layout1.getXpos(), layout2.getXpos());
                    if (c != 0) {
                        return c;
                    }
                }
                float size1 = layout1.getWidth() * layout1.getHeight();
                float size2 = layout2.getWidth() * layout2.getHeight();
                return Float.compare(size1, size2);
            }
        });
        return sortedBoxes;
    }

    private void placeBoxes(List<KNode> sortedBoxes, KNode parentNode, float objSpacing, float borderSpacing, boolean expandNodes) {
        float minHeight;
        float minWidth;
        KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
        KInsets insets = parentLayout.getInsets();
        KVector minSize = (KVector)parentLayout.getProperty(CoreOptions.NODE_SIZE_MINIMUM);
        if (minSize == null) {
            minWidth = Math.max(((Float)parentLayout.getProperty(CoreOptions.NODE_SIZE_MIN_WIDTH)).floatValue() - insets.getLeft() - insets.getRight(), 0.0f);
            minHeight = Math.max(((Float)parentLayout.getProperty(CoreOptions.NODE_SIZE_MIN_HEIGHT)).floatValue() - insets.getTop() - insets.getBottom(), 0.0f);
        } else {
            minWidth = (float)minSize.x;
            minHeight = (float)minSize.y;
        }
        Float aspectRatio = (Float)parentLayout.getProperty(CoreOptions.ASPECT_RATIO);
        if (aspectRatio == null || aspectRatio.floatValue() <= 0.0f) {
            aspectRatio = Float.valueOf(1.3f);
        }
        KVector parentSize = this.placeBoxes(sortedBoxes, objSpacing, borderSpacing, minWidth, minHeight, expandNodes, aspectRatio.floatValue());
        float width = insets.getLeft() + (float)parentSize.x + insets.getRight();
        float height = insets.getTop() + (float)parentSize.y + insets.getBottom();
        ElkUtil.resizeNode(parentNode, width, height, false, true);
    }

    private KVector placeBoxes(List<KNode> sortedBoxes, float minSpacing, float borderSpacing, float minTotalWidth, float minTotalHeight, boolean expandNodes, float aspectRatio) {
        float maxRowWidth = 0.0f;
        float totalArea = 0.0f;
        for (KNode box : sortedBoxes) {
            KShapeLayout boxLayout = (KShapeLayout)box.getData(KShapeLayout.class);
            ElkUtil.resizeNode(box);
            maxRowWidth = Math.max(maxRowWidth, boxLayout.getWidth());
            totalArea += boxLayout.getWidth() * boxLayout.getHeight();
        }
        maxRowWidth = Math.max(maxRowWidth, (float)Math.sqrt(totalArea) * aspectRatio) + borderSpacing;
        float xpos = borderSpacing;
        float ypos = borderSpacing;
        float highestBox = 0.0f;
        float broadestRow = 2.0f * borderSpacing;
        LinkedList<Integer> rowIndices = new LinkedList<Integer>();
        rowIndices.add(0);
        LinkedList<Float> rowHeights = new LinkedList<Float>();
        ListIterator<KNode> boxIter = sortedBoxes.listIterator();
        while (boxIter.hasNext()) {
            KNode box = boxIter.next();
            KShapeLayout boxLayout = (KShapeLayout)box.getData(KShapeLayout.class);
            float width = boxLayout.getWidth();
            float height = boxLayout.getHeight();
            if (xpos + width > maxRowWidth) {
                if (expandNodes) {
                    rowHeights.addLast(Float.valueOf(highestBox));
                    rowIndices.addLast(boxIter.previousIndex());
                }
                xpos = borderSpacing;
                ypos += highestBox + minSpacing;
                highestBox = 0.0f;
                broadestRow = Math.max(broadestRow, 2.0f * borderSpacing + width);
            }
            boxLayout.setPos(xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + width + borderSpacing);
            highestBox = Math.max(highestBox, height);
            xpos += width + minSpacing;
        }
        broadestRow = Math.max(broadestRow, minTotalWidth);
        float totalHeight = ypos + highestBox + borderSpacing;
        if (totalHeight < minTotalHeight) {
            highestBox += minTotalHeight - totalHeight;
            totalHeight = minTotalHeight;
        }
        if (expandNodes) {
            xpos = borderSpacing;
            boxIter = sortedBoxes.listIterator();
            rowIndices.addLast(sortedBoxes.size());
            ListIterator rowIndexIter = rowIndices.listIterator();
            int nextRowIndex = (Integer)rowIndexIter.next();
            rowHeights.addLast(Float.valueOf(highestBox));
            ListIterator rowHeightIter = rowHeights.listIterator();
            float rowHeight = 0.0f;
            while (boxIter.hasNext()) {
                if (boxIter.nextIndex() == nextRowIndex) {
                    xpos = borderSpacing;
                    rowHeight = ((Float)rowHeightIter.next()).floatValue();
                    nextRowIndex = (Integer)rowIndexIter.next();
                }
                KNode box = boxIter.next();
                KShapeLayout boxLayout = (KShapeLayout)box.getData(KShapeLayout.class);
                boxLayout.setHeight(rowHeight);
                if (boxIter.nextIndex() == nextRowIndex) {
                    float newWidth = broadestRow - xpos - borderSpacing;
                    float oldWidth = boxLayout.getWidth();
                    boxLayout.setWidth(newWidth);
                    ElkUtil.translate(box, (newWidth - oldWidth) / 2.0f, 0.0f);
                }
                xpos += boxLayout.getWidth() + minSpacing;
            }
        }
        return new KVector(broadestRow, totalHeight);
    }
}

