/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphiti;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.graphiti.GraphitiDiagramLayoutConnector;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.klayoutdata.impl.KEdgeLayoutImpl;
import org.eclipse.elk.core.klayoutdata.impl.KShapeLayoutImpl;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.nodespacing.Spacing;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.KPort;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class GraphitiLayoutCommand
extends RecordingCommand {
    private final List<Pair<KGraphElement, PictogramElement>> elements = new LinkedList<Pair<KGraphElement, PictogramElement>>();
    private final IFeatureProvider featureProvider;
    private final Map<KEdgeLayout, KVectorChain> bendpointsMap = new HashMap<KEdgeLayout, KVectorChain>();
    private final GraphitiDiagramLayoutConnector layoutManager;

    public GraphitiLayoutCommand(TransactionalEditingDomain domain, IFeatureProvider thefeatureProvider, GraphitiDiagramLayoutConnector manager) {
        super(domain, "Automatic Layout");
        this.featureProvider = thefeatureProvider;
        this.layoutManager = manager;
    }

    protected IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void add(KGraphElement graphElement, PictogramElement pictogramElement) {
        boolean modified = false;
        if (graphElement instanceof KEdge) {
            KEdgeLayoutImpl edgeLayout = (KEdgeLayoutImpl)graphElement.getData(KEdgeLayoutImpl.class);
            modified = edgeLayout.isModified();
        } else {
            KShapeLayoutImpl shapeLayout = (KShapeLayoutImpl)graphElement.getData(KShapeLayoutImpl.class);
            modified = shapeLayout.isModified();
        }
        if (modified) {
            this.elements.add((Pair<KGraphElement, PictogramElement>)new Pair((Object)graphElement, (Object)pictogramElement));
        }
    }

    protected void doExecute() {
        for (Pair<KGraphElement, PictogramElement> entry : this.elements) {
            KGraphElement element = (KGraphElement)entry.getFirst();
            if (element instanceof KPort) {
                this.applyPortLayout((KPort)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (element instanceof KNode) {
                this.applyNodeLayout((KNode)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (element instanceof KEdge) {
                this.applyEdgeLayout((KEdge)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (!(element instanceof KLabel) || !(((KLabel)element).eContainer() instanceof KEdge)) continue;
            this.applyEdgeLabelLayout((KLabel)element, (PictogramElement)entry.getSecond());
        }
        this.bendpointsMap.clear();
    }

    protected void applyPortLayout(KPort kport, PictogramElement pelem) {
        KShapeLayout shapeLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
        this.applyPortLayout(shapeLayout.getXpos(), shapeLayout.getYpos(), pelem, kport.getNode());
    }

    protected void applyPortLayout(double xpos, double ypos, PictogramElement pelem, KNode knode) {
        int offsetx = 0;
        int offsety = 0;
        if (pelem.getGraphicsAlgorithm() != null) {
            offsetx = pelem.getGraphicsAlgorithm().getX();
            offsety = pelem.getGraphicsAlgorithm().getY();
        }
        if (pelem instanceof BoxRelativeAnchor) {
            double relHeight;
            BoxRelativeAnchor anchor = (BoxRelativeAnchor)pelem;
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            double relWidth = (xpos - (double)offsetx) / (double)nodeLayout.getWidth();
            if (relWidth < 0.0) {
                relWidth = 0.0;
            }
            if (relWidth > 1.0) {
                relWidth = 1.0;
            }
            if ((relHeight = (ypos - (double)offsety) / (double)nodeLayout.getHeight()) < 0.0) {
                relHeight = 0.0;
            }
            if (relHeight > 1.0) {
                relHeight = 1.0;
            }
            anchor.setRelativeWidth(relWidth);
            anchor.setRelativeHeight(relHeight);
            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
        } else if (pelem instanceof FixPointAnchor) {
            FixPointAnchor anchor = (FixPointAnchor)pelem;
            anchor.getLocation().setX((int)(xpos - (double)offsetx));
            anchor.getLocation().setY((int)(ypos - (double)offsety));
        }
    }

    protected void applyNodeLayout(KNode knode, PictogramElement pelem) {
        KShapeLayout shapeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        GraphicsAlgorithm ga = pelem.getGraphicsAlgorithm();
        float xpos = shapeLayout.getXpos();
        float ypos = shapeLayout.getYpos();
        if (knode.getParent() != null) {
            KShapeLayout parentLayout = (KShapeLayout)knode.getParent().getData(KShapeLayout.class);
            KInsets parentInsets = parentLayout.getInsets();
            Spacing.Margins parentMargins = (Spacing.Margins)parentLayout.getProperty(CoreOptions.MARGINS);
            xpos = (float)((double)xpos + (parentMargins.left + (double)parentInsets.getLeft()));
            ypos = (float)((double)ypos + (parentMargins.top + (double)parentInsets.getTop()));
        }
        float width = shapeLayout.getWidth();
        float height = shapeLayout.getHeight();
        Spacing.Margins nodeMargins = (Spacing.Margins)shapeLayout.getProperty(CoreOptions.MARGINS);
        xpos = (float)((double)xpos - nodeMargins.left);
        ypos = (float)((double)ypos - nodeMargins.top);
        width = (float)((double)width + (nodeMargins.left + nodeMargins.right));
        height = (float)((double)height + (nodeMargins.top + nodeMargins.bottom));
        ga.setX(Math.round(xpos));
        ga.setY(Math.round(ypos));
        ga.setWidth(Math.round(width));
        ga.setHeight(Math.round(height));
        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
    }

    protected void applyEdgeLayout(KEdge kedge, PictogramElement pelem) {
        KVectorChain bendPoints = this.getBendPoints(kedge);
        if (pelem instanceof FreeFormConnection) {
            FreeFormConnection connection = (FreeFormConnection)pelem;
            EList pointList = connection.getBendpoints();
            int i = 0;
            while (i < bendPoints.size()) {
                Point point;
                KVector kpoint = (KVector)bendPoints.get(i);
                if (i >= pointList.size()) {
                    point = Graphiti.getGaService().createPoint((int)Math.round(kpoint.x), (int)Math.round(kpoint.y));
                    pointList.add(point);
                } else {
                    point = (Point)pointList.get(i);
                    point.setX((int)Math.round(kpoint.x));
                    point.setY((int)Math.round(kpoint.y));
                }
                ++i;
            }
            while (pointList.size() > bendPoints.size()) {
                pointList.remove(pointList.size() - 1);
            }
            if (kedge.getSourcePort() == null) {
                KNode source = kedge.getSource();
                KPoint sourcePoint = ((KEdgeLayout)kedge.getData(KEdgeLayout.class)).getSourcePoint();
                float xpos = sourcePoint.getX();
                float ypos = sourcePoint.getY();
                if (ElkUtil.isDescendant((KNode)kedge.getTarget(), (KNode)source)) {
                    KInsets insets = ((KShapeLayout)source.getData(KShapeLayout.class)).getInsets();
                    xpos += insets.getLeft();
                    ypos += insets.getTop();
                } else {
                    KShapeLayout sourceLayout = (KShapeLayout)source.getData(KShapeLayout.class);
                    xpos -= sourceLayout.getXpos();
                    ypos -= sourceLayout.getYpos();
                }
                this.applyPortLayout(xpos, ypos, (PictogramElement)connection.getStart(), source);
            }
            if (kedge.getTargetPort() == null) {
                KNode target = kedge.getTarget();
                KVector targetPoint = ((KEdgeLayout)kedge.getData(KEdgeLayout.class)).getTargetPoint().createVector();
                KNode referenceNode = kedge.getSource();
                if (!ElkUtil.isDescendant((KNode)target, (KNode)referenceNode)) {
                    referenceNode = referenceNode.getParent();
                }
                ElkUtil.toAbsolute((KVector)targetPoint, (KNode)referenceNode);
                ElkUtil.toRelative((KVector)targetPoint, (KNode)target);
                this.applyPortLayout(targetPoint.x, targetPoint.y, (PictogramElement)connection.getEnd(), target);
            }
        }
    }

    public KVectorChain getBendPoints(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KVectorChain bendPoints = this.bendpointsMap.get(edgeLayout);
        if (bendPoints == null) {
            KNode parent = edge.getSource();
            if (!ElkUtil.isDescendant((KNode)edge.getTarget(), (KNode)parent)) {
                parent = parent.getParent();
            }
            KVector offset = new KVector();
            ElkUtil.toAbsolute((KVector)offset, (KNode)parent);
            bendPoints = new KVectorChain();
            KPoint sourcePoint = edgeLayout.getSourcePoint();
            bendPoints.add((double)sourcePoint.getX() + offset.x, (double)sourcePoint.getY() + offset.y);
            for (KPoint bendPoint : edgeLayout.getBendPoints()) {
                bendPoints.add((double)bendPoint.getX() + offset.x, (double)bendPoint.getY() + offset.y);
            }
            KPoint targetPoint = edgeLayout.getTargetPoint();
            bendPoints.add((double)targetPoint.getX() + offset.x, (double)targetPoint.getY() + offset.y);
            EdgeRouting edgeRouting = (EdgeRouting)edgeLayout.getProperty(CoreOptions.EDGE_ROUTING);
            if (edgeRouting == EdgeRouting.SPLINES && edgeLayout.getBendPoints().size() >= 1) {
                bendPoints = ElkMath.approximateBezierSpline((KVectorChain)bendPoints);
            }
            bendPoints.removeFirst();
            bendPoints.removeLast();
            this.bendpointsMap.put(edgeLayout, bendPoints);
        }
        return bendPoints;
    }

    protected void applyEdgeLabelLayout(KLabel klabel, PictogramElement pelem) {
        GraphicsAlgorithm ga = pelem.getGraphicsAlgorithm();
        ConnectionDecorator decorator = (ConnectionDecorator)pelem;
        KEdge kedge = (KEdge)klabel.eContainer();
        KVectorChain bendPoints = new KVectorChain((Collection)this.getBendPoints(kedge));
        KVector sourcePoint = this.layoutManager.calculateAnchorEnds(kedge.getSource(), kedge.getSourcePort(), null);
        bendPoints.addFirst((Object)sourcePoint);
        KVector targetPoint = this.layoutManager.calculateAnchorEnds(kedge.getTarget(), kedge.getTargetPort(), null);
        bendPoints.addLast((Object)targetPoint);
        KVector referencePoint = decorator.isLocationRelative() ? bendPoints.pointOnLine(decorator.getLocation() * bendPoints.totalLength()) : bendPoints.pointOnLine(decorator.getLocation());
        KShapeLayout shapeLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
        KVector position = shapeLayout.createVector();
        KNode parent = kedge.getSource();
        if (!ElkUtil.isDescendant((KNode)kedge.getTarget(), (KNode)parent)) {
            parent = parent.getParent();
        }
        ElkUtil.toAbsolute((KVector)position, (KNode)parent);
        ga.setX((int)Math.round(position.x - referencePoint.x));
        ga.setY((int)Math.round(position.y - referencePoint.y));
    }
}

