/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeJoiner;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.nodespacing.LabelSide;

public final class LabelDummyRemover
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label dummy removal", 1.0f);
        float labelSpacing = ((Float)layeredGraph.getProperty(LayeredOptions.SPACING_LABEL)).floatValue();
        Direction layoutDirection = (Direction)layeredGraph.getProperty(LayeredOptions.DIRECTION);
        for (Layer layer : layeredGraph.getLayers()) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.LABEL) continue;
                LEdge originEdge = (LEdge)((Object)node.getProperty(InternalProperties.ORIGIN));
                double thickness = ((Float)originEdge.getProperty(LayeredOptions.EDGE_THICKNESS)).doubleValue();
                KVector currLabelPos = new KVector(node.getPosition());
                if (node.getProperty(InternalProperties.LABEL_SIDE) == LabelSide.BELOW) {
                    currLabelPos.y += thickness + (double)labelSpacing;
                }
                KVector labelSpace = new KVector(node.getSize().x, node.getSize().y - thickness - (double)labelSpacing);
                List representedLabels = (List)node.getProperty(InternalProperties.REPRESENTED_LABELS);
                if (layoutDirection.isVertical()) {
                    this.placeLabelsForVerticalLayout(representedLabels, currLabelPos, labelSpacing, labelSpace, node.getProperty(InternalProperties.LABEL_SIDE) != LabelSide.ABOVE);
                } else {
                    this.placeLabelsForHorizontalLayout(representedLabels, currLabelPos, labelSpacing, labelSpace);
                }
                originEdge.getLabels().addAll(representedLabels);
                LongEdgeJoiner.joinAt(node, false);
                nodeIterator.remove();
            }
        }
        monitor.done();
    }

    private void placeLabelsForHorizontalLayout(List<LLabel> labels, KVector labelPos, double labelSpacing, KVector labelSpace) {
        for (LLabel label : labels) {
            label.getPosition().x = labelPos.x + (labelSpace.x - label.getSize().x) / 2.0;
            label.getPosition().y = labelPos.y;
            labelPos.y += label.getSize().y + labelSpacing;
        }
    }

    private void placeLabelsForVerticalLayout(List<LLabel> labels, KVector labelPos, double labelSpacing, KVector labelSpace, boolean leftAligned) {
        for (LLabel label : labels) {
            label.getPosition().x = labelPos.x;
            label.getPosition().y = leftAligned ? labelPos.y : labelPos.y + labelSpace.y - label.getSize().y;
            labelPos.x += label.getSize().x + labelSpacing;
        }
    }
}

