/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.PortIterable;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class NorthSouthEdgeNeighbouringNodeCrossingsCounter {
    private int upperLowerCrossings;
    private int lowerUpperCrossings;
    private final Map<LPort, Integer> portPositions;
    private final LNode[] layer;
    private final boolean usesOrthogonalLayout;

    public NorthSouthEdgeNeighbouringNodeCrossingsCounter(LNode[] nodes) {
        this.usesOrthogonalLayout = nodes[0].getGraph().getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL;
        this.layer = nodes;
        this.portPositions = new HashMap<LPort, Integer>();
        this.initializePortPositions();
    }

    private void initializePortPositions() {
        LNode[] lNodeArray = this.layer;
        int n = this.layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            this.setPortIdsOn(node, PortSide.SOUTH);
            this.setPortIdsOn(node, PortSide.NORTH);
            ++n2;
        }
    }

    private void setPortIdsOn(LNode node, PortSide side) {
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, side);
        int portId = 0;
        for (LPort port : ports) {
            this.portPositions.put(port, portId++);
        }
    }

    public void countCrossings(LNode upperNode, LNode lowerNode) {
        this.upperLowerCrossings = 0;
        this.lowerUpperCrossings = 0;
        this.processIfTwoNorthSouthNodes(upperNode, lowerNode);
        this.processIfNorthSouthLongEdgeDummyCrossing(upperNode, lowerNode);
        this.processIfNormalNodeWithNSPortsAndLongEdgeDummy(upperNode, lowerNode);
    }

    private void processIfTwoNorthSouthNodes(LNode upperNode, LNode lowerNode) {
        if (this.isNorthSouth(upperNode) && this.isNorthSouth(lowerNode)) {
            if (this.noFixedPortOrderOn(this.originOf(upperNode)) || this.haveDifferentOrigins(upperNode, lowerNode)) {
                return;
            }
            if (this.hasEdgesInBothDirections(upperNode) || this.hasEdgesInBothDirections(lowerNode)) {
                this.upperLowerCrossings = 1;
                this.lowerUpperCrossings = 1;
                return;
            }
            PortSide upperNodePortSide = this.getPortDirectionFromNorthSouthNode(upperNode);
            PortSide lowerNodePortSide = this.getPortDirectionFromNorthSouthNode(lowerNode);
            if (this.isNorthOfNormalNode(upperNode)) {
                this.countCrossingsOfTwoNorthSouthDummies(upperNode, lowerNode, upperNodePortSide, lowerNodePortSide);
            } else {
                this.countCrossingsOfTwoNorthSouthDummies(lowerNode, upperNode, lowerNodePortSide, upperNodePortSide);
            }
        }
    }

    private boolean hasEdgesInBothDirections(LNode n) {
        boolean east = false;
        boolean west = false;
        for (LPort p : n.getPorts()) {
            east |= p.getSide() == PortSide.EAST;
            west |= p.getSide() == PortSide.WEST;
        }
        return east && west;
    }

    private void countCrossingsOfTwoNorthSouthDummies(LNode furtherFromNormalNode, LNode closerToNormalNode, PortSide furtherNodePortSide, PortSide closerNodePortSide) {
        if (furtherNodePortSide == PortSide.EAST && closerNodePortSide == PortSide.EAST) {
            if (this.originPortPositionOf(furtherFromNormalNode) > this.originPortPositionOf(closerToNormalNode)) {
                this.upperLowerCrossings = this.numberOfEdgesConnectTo(closerToNormalNode);
            } else {
                this.lowerUpperCrossings = this.numberOfEdgesConnectTo(furtherFromNormalNode);
            }
        } else if (furtherNodePortSide == PortSide.WEST && closerNodePortSide == PortSide.WEST) {
            if (this.originPortPositionOf(furtherFromNormalNode) < this.originPortPositionOf(closerToNormalNode)) {
                this.upperLowerCrossings = this.numberOfEdgesConnectTo(closerToNormalNode);
            } else {
                this.lowerUpperCrossings = this.numberOfEdgesConnectTo(furtherFromNormalNode);
            }
        } else if (furtherNodePortSide == PortSide.WEST && closerNodePortSide == PortSide.EAST) {
            if (this.originPortPositionOf(furtherFromNormalNode) > this.originPortPositionOf(closerToNormalNode)) {
                this.upperLowerCrossings = this.numberOfEdgesConnectTo(closerToNormalNode);
                this.lowerUpperCrossings = this.numberOfEdgesConnectTo(furtherFromNormalNode);
            }
        } else if (this.originPortPositionOf(furtherFromNormalNode) < this.originPortPositionOf(closerToNormalNode)) {
            this.upperLowerCrossings = this.numberOfEdgesConnectTo(closerToNormalNode);
            this.lowerUpperCrossings = this.numberOfEdgesConnectTo(furtherFromNormalNode);
        }
    }

    private void processIfNorthSouthLongEdgeDummyCrossing(LNode upperNode, LNode lowerNode) {
        if (this.isNorthSouth(upperNode) && this.isLongEdgeDummy(lowerNode)) {
            if (this.isNorthOfNormalNode(upperNode)) {
                this.upperLowerCrossings = 1;
            } else {
                this.lowerUpperCrossings = 1;
            }
        } else if (this.isNorthSouth(lowerNode) && this.isLongEdgeDummy(upperNode)) {
            if (this.isNorthOfNormalNode(lowerNode)) {
                this.lowerUpperCrossings = 1;
            } else {
                this.upperLowerCrossings = 1;
            }
        }
    }

    private void processIfNormalNodeWithNSPortsAndLongEdgeDummy(LNode upperNode, LNode lowerNode) {
        if (this.isNormal(upperNode) && this.isLongEdgeDummy(lowerNode)) {
            this.upperLowerCrossings = this.numberOfNorthSouthEdges(upperNode, PortSide.SOUTH);
            this.lowerUpperCrossings = this.numberOfNorthSouthEdges(upperNode, PortSide.NORTH);
        }
        if (this.isNormal(lowerNode) && this.isLongEdgeDummy(upperNode)) {
            this.upperLowerCrossings = this.numberOfNorthSouthEdges(lowerNode, PortSide.NORTH);
            this.lowerUpperCrossings = this.numberOfNorthSouthEdges(lowerNode, PortSide.SOUTH);
        }
    }

    private int numberOfNorthSouthEdges(LNode node, PortSide side) {
        int numberOfEdges = 0;
        for (LPort port : node.getPorts(side)) {
            numberOfEdges += this.hasConnectedNorthSouthEdge(port) ? 1 : 0;
        }
        return numberOfEdges;
    }

    private boolean hasConnectedNorthSouthEdge(LPort port) {
        return port.getProperty(InternalProperties.PORT_DUMMY) != null;
    }

    private boolean haveDifferentOrigins(LNode upperNode, LNode lowerNode) {
        return this.originOf(upperNode) != this.originOf(lowerNode);
    }

    private PortSide getPortDirectionFromNorthSouthNode(LNode node) {
        boolean northSouthNodeOnlyHasOneInBetweenLayerEdge;
        assert (this.isNorthSouth(node));
        boolean bl = northSouthNodeOnlyHasOneInBetweenLayerEdge = node.getPorts().size() == 1;
        assert (northSouthNodeOnlyHasOneInBetweenLayerEdge);
        return node.getPorts().get(0).getSide();
    }

    private int originPortPositionOf(LNode node) {
        LPort origin;
        LPort port = origin = this.originPortOf(node);
        return this.portPositions.get((Object)port);
    }

    private LPort originPortOf(LNode node) {
        LPort port = node.getPorts().get(0);
        LPort origin = (LPort)((Object)port.getProperty(InternalProperties.ORIGIN));
        return origin;
    }

    private boolean isNorthOfNormalNode(LNode upperNode) {
        return this.originPortOf(upperNode).getSide() == PortSide.NORTH;
    }

    private LNode originOf(LNode node) {
        return (LNode)((Object)node.getProperty(InternalProperties.ORIGIN));
    }

    private boolean noFixedPortOrderOn(LNode node) {
        return !((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed();
    }

    private boolean isLongEdgeDummy(LNode node) {
        return node.getType() == LNode.NodeType.LONG_EDGE;
    }

    private boolean isNorthSouth(LNode node) {
        return node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    private int numberOfEdgesConnectTo(LNode node) {
        if (this.usesOrthogonalLayout) {
            return 1;
        }
        int n = 0;
        for (LPort port : node.getPorts()) {
            n += port.getDegree();
        }
        return n;
    }

    private boolean isNormal(LNode node) {
        return node.getType() == LNode.NodeType.NORMAL;
    }

    public int getUpperLowerCrossings() {
        return this.upperLowerCrossings;
    }

    public int getLowerUpperCrossings() {
        return this.lowerUpperCrossings;
    }
}

