/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.GraphFeature;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.core.util.InstancePool;

public final class LayoutAlgorithmData
implements ILayoutMetaData {
    private final String id;
    private final String name;
    private final InstancePool<AbstractLayoutProvider> providerPool;
    private final String category;
    private final String bundle;
    private final String description;
    private final String imagePath;
    private final Set<GraphFeature> supportedFeatures;
    private final Map<LayoutOptionData, Object> knownOptions = Maps.newHashMap();

    public LayoutAlgorithmData(String aid, String aname, String adescription, IFactory<AbstractLayoutProvider> providerFactory, String acategory, String abundle, String aimagePath, Set<GraphFeature> asupportedFeatures) {
        this.id = aid;
        this.name = aname;
        this.description = adescription;
        this.providerPool = new InstancePool<AbstractLayoutProvider>(providerFactory);
        this.category = acategory;
        this.bundle = abundle;
        this.imagePath = aimagePath;
        this.supportedFeatures = asupportedFeatures == null ? EnumSet.noneOf(GraphFeature.class) : asupportedFeatures;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutAlgorithmData) {
            return this.id.equals(((LayoutAlgorithmData)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Layout Algorithm: " + this.id;
    }

    public void addKnownOption(LayoutOptionData optionData, Object defaultValue) {
        this.knownOptions.put(optionData, defaultValue);
    }

    public boolean knowsOption(LayoutOptionData optionData) {
        return this.knownOptions.containsKey(optionData);
    }

    public Object getDefaultValue(LayoutOptionData optionData) {
        return this.knownOptions.get(optionData);
    }

    public boolean supportsFeature(GraphFeature graphFeature) {
        return this.supportedFeatures.contains((Object)graphFeature);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public InstancePool<AbstractLayoutProvider> getInstancePool() {
        return this.providerPool;
    }

    public String getCategoryId() {
        return this.category;
    }

    public String getBundleName() {
        return this.bundle;
    }

    public String getPreviewImagePath() {
        return this.imagePath;
    }
}

