/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.Pair;

public class LayoutMetaDataService {
    private static LayoutMetaDataService instance;
    private final Map<String, LayoutAlgorithmData> layoutAlgorithmMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> layoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> legacyLayoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutCategoryData> layoutCategoryMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutAlgorithmData> algorithmSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutOptionData> optionSuffixMap = Maps.newHashMap();

    public static synchronized LayoutMetaDataService getInstance() {
        if (instance == null) {
            instance = new LayoutMetaDataService();
            instance.registerLayoutMetaDataProvider(new CoreOptions());
            try {
                Class.forName("org.eclipse.elk.core.service.ElkServicePlugin");
            }
            catch (Exception exception) {}
        }
        return instance;
    }

    public static synchronized void unload() {
        if (instance != null) {
            for (LayoutAlgorithmData algoData : instance.getAlgorithmData()) {
                algoData.getInstancePool().clear();
            }
            instance = null;
        }
    }

    public final void registerLayoutMetaDataProvider(ILayoutMetaDataProvider provider) {
        Registry registry = new Registry();
        provider.apply(registry);
        registry.applyDependencies();
    }

    public final LayoutAlgorithmData getAlgorithmData(String id) {
        return this.layoutAlgorithmMap.get(id);
    }

    public final Collection<LayoutAlgorithmData> getAlgorithmData() {
        return Collections.unmodifiableCollection(this.layoutAlgorithmMap.values());
    }

    public final LayoutAlgorithmData getAlgorithmDataBySuffix(String suffix) {
        LayoutAlgorithmData data = this.layoutAlgorithmMap.get(suffix);
        if (data == null && (data = this.algorithmSuffixMap.get(suffix)) == null) {
            for (LayoutAlgorithmData d : this.layoutAlgorithmMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.algorithmSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final LayoutAlgorithmData getAlgorithmDataOrDefault(String algorithmId, String defaultId) {
        String finalDefaultId = defaultId == null ? "" : defaultId;
        String finalAlgorithmId = algorithmId == null || algorithmId.isEmpty() ? finalDefaultId : algorithmId;
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        LayoutAlgorithmData result = layoutDataService.getAlgorithmData(finalAlgorithmId);
        if (result != null) {
            return result;
        }
        Collection<LayoutAlgorithmData> allAlgorithmData = layoutDataService.getAlgorithmData();
        if (!allAlgorithmData.isEmpty()) {
            return allAlgorithmData.iterator().next();
        }
        return null;
    }

    public final LayoutOptionData getOptionData(String id) {
        LayoutOptionData data = this.layoutOptionMap.get(id);
        return data != null ? data : this.legacyLayoutOptionMap.get(id);
    }

    public final Collection<LayoutOptionData> getOptionData() {
        return Collections.unmodifiableCollection(this.layoutOptionMap.values());
    }

    public final LayoutOptionData getOptionDataBySuffix(String suffix) {
        if (suffix == null || suffix.trim().isEmpty()) {
            return null;
        }
        LayoutOptionData data = this.layoutOptionMap.get(suffix);
        if (data != null) {
            return data;
        }
        data = this.legacyLayoutOptionMap.get(suffix);
        if (data != null) {
            return data;
        }
        data = this.optionSuffixMap.get(suffix);
        return data;
    }

    public final List<LayoutOptionData> getOptionData(LayoutAlgorithmData algorithmData, LayoutOptionData.Target targetType) {
        LinkedList<LayoutOptionData> optionDataList = new LinkedList<LayoutOptionData>();
        for (LayoutOptionData optionData : this.layoutOptionMap.values()) {
            if (!algorithmData.knowsOption(optionData) && !CoreOptions.ALGORITHM.equals((Object)optionData) || !optionData.getTargets().contains((Object)targetType)) continue;
            optionDataList.add(optionData);
        }
        return optionDataList;
    }

    public final LayoutCategoryData getCategoryData(String id) {
        return this.layoutCategoryMap.get(id);
    }

    public final Collection<LayoutCategoryData> getCategoryData() {
        return Collections.unmodifiableCollection(this.layoutCategoryMap.values());
    }

    private class Registry
    implements ILayoutMetaDataProvider.Registry {
        private final List<Triple> optionDependencies = new LinkedList<Triple>();
        private final List<Triple> optionSupport = new LinkedList<Triple>();

        private Registry() {
        }

        @Override
        public void register(LayoutAlgorithmData algorithmData) {
            LayoutMetaDataService.this.layoutAlgorithmMap.put(algorithmData.getId(), algorithmData);
        }

        @Override
        public void register(LayoutOptionData optionData) {
            String id = optionData.getId();
            LayoutMetaDataService.this.layoutOptionMap.put(id, optionData);
            String suffix = id.substring(id.lastIndexOf(46) + 1, id.length());
            if (optionData.getGroup() != null && !optionData.getGroup().isEmpty()) {
                suffix = String.valueOf(optionData.getGroup()) + '.' + suffix;
            }
            String[] split = suffix.split("\\.");
            StringBuilder tmpSuffix = new StringBuilder();
            int i = split.length - 1;
            do {
                if (tmpSuffix.length() > 0) {
                    tmpSuffix.insert(0, '.');
                }
                tmpSuffix.insert(0, split[i]);
                if (LayoutMetaDataService.this.optionSuffixMap.containsKey(tmpSuffix.toString())) {
                    LayoutMetaDataService.this.optionSuffixMap.put(tmpSuffix.toString(), null);
                    continue;
                }
                LayoutMetaDataService.this.optionSuffixMap.put(tmpSuffix.toString(), optionData);
            } while (--i >= 0);
            if (optionData.getLegacyIds() != null) {
                String[] stringArray = optionData.getLegacyIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String legacyId = stringArray[n2];
                    LayoutMetaDataService.this.legacyLayoutOptionMap.put(legacyId, optionData);
                    String legacySuffix = legacyId.substring(legacyId.lastIndexOf(46) + 1, legacyId.length());
                    if (!LayoutMetaDataService.this.optionSuffixMap.containsKey(legacySuffix)) {
                        LayoutMetaDataService.this.optionSuffixMap.put(legacySuffix, optionData);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void register(LayoutCategoryData categoryData) {
            LayoutMetaDataService.this.layoutCategoryMap.put(categoryData.getId(), categoryData);
        }

        @Override
        public void addDependency(String sourceOption, String targetOption, Object requiredValue) {
            Triple dep = new Triple();
            dep.firstId = sourceOption;
            dep.secondId = targetOption;
            dep.value = requiredValue;
            this.optionDependencies.add(dep);
        }

        @Override
        public void addOptionSupport(String algorithm, String option, Object defaultValue) {
            Triple sup = new Triple();
            sup.firstId = algorithm;
            sup.secondId = option;
            sup.value = defaultValue;
            this.optionSupport.add(sup);
        }

        private void applyDependencies() {
            for (LayoutAlgorithmData algorithm : LayoutMetaDataService.this.layoutAlgorithmMap.values()) {
                LayoutCategoryData category;
                String categoryId = algorithm.getCategoryId();
                if (categoryId == null) {
                    categoryId = "";
                }
                if ((category = LayoutMetaDataService.this.getCategoryData(categoryId)) == null && categoryId.isEmpty()) {
                    category = this.retrieveBackupCategory();
                }
                if (category == null || category.getLayouters().contains(algorithm)) continue;
                category.getLayouters().add(algorithm);
            }
            for (Triple dep : this.optionDependencies) {
                LayoutOptionData source = LayoutMetaDataService.this.getOptionData(dep.firstId);
                LayoutOptionData target = LayoutMetaDataService.this.getOptionData(dep.secondId);
                if (source == null || target == null) continue;
                source.getDependencies().add(Pair.of(target, dep.value));
            }
            this.optionDependencies.clear();
            for (Triple sup : this.optionSupport) {
                LayoutAlgorithmData algorithm = LayoutMetaDataService.this.getAlgorithmData(sup.firstId);
                LayoutOptionData option = LayoutMetaDataService.this.getOptionData(sup.secondId);
                if (algorithm == null || option == null) continue;
                algorithm.addKnownOption(option, sup.value);
            }
            this.optionSupport.clear();
        }

        private LayoutCategoryData retrieveBackupCategory() {
            LayoutCategoryData otherCategory = (LayoutCategoryData)LayoutMetaDataService.this.layoutCategoryMap.get("");
            if (otherCategory == null) {
                otherCategory = new LayoutCategoryData("", "Other", null);
                LayoutMetaDataService.this.layoutCategoryMap.put("", otherCategory);
            }
            return otherCategory;
        }

        private class Triple {
            private String firstId;
            private String secondId;
            private Object value;

            private Triple() {
            }
        }
    }
}

