/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.rendering;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.EdgeType;
import org.eclipse.elk.core.ui.rendering.GraphRenderingConfigurator;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.KPort;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GraphRenderer {
    private static final double ARROW_LENGTH = 8.0;
    private static final double ARROW_WIDTH = 7.0;
    private static final int MIN_FONT_HEIGHT = 3;
    private final Map<Object, PaintRectangle> boundsMap = new LinkedHashMap<Object, PaintRectangle>();
    private GraphRenderingConfigurator configurator;
    private double scale = 1.0;
    private KVector baseOffset = new KVector();
    private KNode mostRecentlyDrawnGraph = null;

    public GraphRenderer(GraphRenderingConfigurator configurator) {
        this(configurator, 1.0);
    }

    public GraphRenderer(GraphRenderingConfigurator configurator, double scale) {
        this.scale = scale;
        this.configurator = configurator;
        this.configurator.initialize(scale);
    }

    public void dispose() {
        this.flushCache();
        this.mostRecentlyDrawnGraph = null;
        this.configurator.dispose();
    }

    public KVector getBaseOffset() {
        return this.baseOffset;
    }

    public void setBaseOffset(KVector baseOffset) {
        this.baseOffset = baseOffset == null ? new KVector() : baseOffset;
    }

    public void markDirty(Rectangle area) {
        for (PaintRectangle rectangle : this.boundsMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
    }

    private void flushCache() {
        this.boundsMap.clear();
    }

    public void render(KNode parentNode, GC graphics, Rectangle area) {
        if (this.mostRecentlyDrawnGraph != parentNode) {
            this.flushCache();
            this.mostRecentlyDrawnGraph = parentNode;
        }
        graphics.setInterpolation(2);
        int maxDepth = Math.max(this.maxDepth(parentNode), 1);
        int nodeAlpha = 200 / maxDepth + 55;
        HashSet<KEdge> edgeSet = new HashSet<KEdge>();
        this.renderNodeChildren(parentNode, graphics, area, this.baseOffset, edgeSet, nodeAlpha);
        for (KEdge edge : edgeSet) {
            this.renderEdge(parentNode, edge, graphics, area, nodeAlpha);
        }
    }

    private void renderNodeChildren(KNode parent, GC graphics, Rectangle area, KVector offset, Set<KEdge> edgeSet, int nodeAlpha) {
        for (KNode child : parent.getChildren()) {
            PaintRectangle rect = this.boundsMap.get(child);
            if (rect == null) {
                rect = new PaintRectangle((KShapeLayout)child.getData(KShapeLayout.class), offset, this.scale);
                this.boundsMap.put(child, rect);
            }
            KVector childOffset = new KVector((double)rect.x, (double)rect.y);
            if (!rect.painted && rect.intersects(area)) {
                graphics.setAlpha(nodeAlpha);
                if (this.configurator.getNodeFillColor() != null) {
                    graphics.setBackground(this.configurator.getNodeFillColor());
                    graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if (this.configurator.getNodeBorderColor() != null) {
                    graphics.setForeground(this.configurator.getNodeBorderColor());
                    graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                rect.painted = true;
                KVector contentOffset = new KVector(childOffset);
                KInsets insets = ((KShapeLayout)child.getData(KShapeLayout.class)).getInsets();
                contentOffset.add((double)insets.getLeft() * this.scale, (double)insets.getTop() * this.scale);
                this.renderNodeChildren(child, graphics, area, contentOffset, edgeSet, nodeAlpha);
            }
            if (this.configurator.getNodeLabelFont() != null) {
                graphics.setFont(this.configurator.getNodeLabelFont());
                for (KLabel label : child.getLabels()) {
                    this.renderLabel(label, graphics, area, childOffset, nodeAlpha);
                }
            }
            for (KPort port : child.getPorts()) {
                this.renderPort(port, graphics, area, childOffset, nodeAlpha);
            }
            edgeSet.addAll((Collection<KEdge>)child.getIncomingEdges());
            edgeSet.addAll((Collection<KEdge>)child.getOutgoingEdges());
        }
    }

    private void renderLabel(KLabel label, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        if (graphics.getFont().getFontData()[0].getHeight() >= 3) {
            PaintRectangle rect = this.boundsMap.get(label);
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            if (rect == null) {
                rect = new PaintRectangle(labelLayout, offset, this.scale);
                this.boundsMap.put(label, rect);
            }
            if (!rect.painted && rect.intersects(area)) {
                String text;
                graphics.setAlpha(labelAlpha);
                if (this.configurator.getLabelFillColor() != null) {
                    graphics.setBackground(this.configurator.getLabelFillColor());
                    graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if (this.configurator.getLabelBorderColor() != null) {
                    graphics.setForeground(this.configurator.getLabelBorderColor());
                    graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if ((text = label.getText()) != null && text.length() > 0) {
                    graphics.setAlpha(255);
                    graphics.setForeground(this.configurator.getLabelTextColor());
                    Rectangle oldClip = graphics.getClipping();
                    graphics.setClipping(rect.x, rect.y, rect.width, rect.height);
                    graphics.drawString(text, rect.x, rect.y, true);
                    graphics.setClipping(oldClip);
                }
                rect.painted = true;
            }
        }
    }

    private void renderPort(KPort port, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        PaintRectangle rect = this.boundsMap.get(port);
        if (rect == null) {
            rect = new PaintRectangle((KShapeLayout)port.getData(KShapeLayout.class), offset, this.scale);
            this.boundsMap.put(port, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            graphics.setAlpha(255);
            if (this.configurator.getPortFillColor() != null) {
                graphics.setBackground(this.configurator.getPortFillColor());
                graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            }
            if (this.configurator.getPortBorderColor() != null) {
                graphics.setForeground(this.configurator.getPortBorderColor());
                graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
            }
            rect.painted = true;
        }
        if (this.configurator.getPortLabelFont() != null) {
            graphics.setFont(this.configurator.getPortLabelFont());
            KVector portOffset = new KVector((double)rect.x, (double)rect.y);
            for (KLabel label : port.getLabels()) {
                this.renderLabel(label, graphics, area, portOffset, labelAlpha);
            }
        }
    }

    private void renderEdge(KNode graph, KEdge edge, GC graphics, Rectangle area, int labelAlpha) {
        KVectorChain vc;
        if (this.configurator.getEdgeColor() == null) {
            return;
        }
        if (!ElkUtil.isDescendant((KNode)edge.getSource(), (KNode)graph) || !ElkUtil.isDescendant((KNode)edge.getTarget(), (KNode)graph)) {
            return;
        }
        KNode parent = edge.getSource();
        if (!ElkUtil.isDescendant((KNode)edge.getTarget(), (KNode)parent)) {
            parent = parent.getParent();
        }
        KNode node = parent;
        KVector offset = new KVector();
        while (node != graph) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            offset.add((double)(nodeLayout.getXpos() + insets.getLeft()), (double)(nodeLayout.getYpos() + insets.getTop()));
            node = node.getParent();
        }
        offset.scale(this.scale).add(this.baseOffset);
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        PaintRectangle rect = this.boundsMap.get(edge);
        if (rect == null) {
            rect = new PaintRectangle(edgeLayout, offset, this.scale);
            this.boundsMap.put(edge, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            int[] arrowPoly;
            graphics.setAlpha(255);
            graphics.setForeground(this.configurator.getEdgeColor());
            graphics.setBackground(this.configurator.getEdgeColor());
            KVectorChain bendPoints = edgeLayout.createVectorChain();
            if (edgeLayout.getProperty(CoreOptions.EDGE_ROUTING) == EdgeRouting.SPLINES) {
                bendPoints = ElkMath.approximateBezierSpline((KVectorChain)bendPoints);
            }
            bendPoints.scale(this.scale).offset(offset);
            KVector point1 = (KVector)bendPoints.getFirst();
            for (KVector point2 : bendPoints) {
                graphics.drawLine((int)Math.round(point1.x), (int)Math.round(point1.y), (int)Math.round(point2.x), (int)Math.round(point2.y));
                point1 = point2;
            }
            if (edgeLayout.getProperty(CoreOptions.EDGE_TYPE) != EdgeType.UNDIRECTED && (arrowPoly = this.makeArrow((KVector)bendPoints.get(bendPoints.size() - 2), (KVector)bendPoints.getLast())) != null) {
                graphics.fillPolygon(arrowPoly);
            }
            rect.painted = true;
        }
        if ((vc = (KVectorChain)edgeLayout.getProperty(CoreOptions.JUNCTION_POINTS)) != null) {
            for (KVector v : vc) {
                KVector center = v.clone().scale(this.scale).add(offset).sub(2.0, 2.0);
                graphics.fillOval((int)center.x, (int)center.y, 6, 6);
            }
        }
        if (this.configurator.getEdgeLabelFont() != null) {
            graphics.setFont(this.configurator.getEdgeLabelFont());
            for (KLabel label : edge.getLabels()) {
                this.renderLabel(label, graphics, area, offset, labelAlpha);
            }
        }
    }

    private int[] makeArrow(KVector point1, KVector point2) {
        if ((point1.x != point2.x || point1.y != point2.y) && 7.0 * this.scale >= 2.0) {
            int[] arrow = new int[6];
            arrow[0] = (int)Math.round(point2.x);
            arrow[1] = (int)Math.round(point2.y);
            double vectX = point1.x - point2.x;
            double vectY = point1.y - point2.y;
            double length = Math.sqrt(vectX * vectX + vectY * vectY);
            double normX = vectX / length;
            double normY = vectY / length;
            double neckX = point2.x + 8.0 * normX * this.scale;
            double neckY = point2.y + 8.0 * normY * this.scale;
            double orthX = normY * 7.0 / 2.0 * this.scale;
            double orthY = -normX * 7.0 / 2.0 * this.scale;
            arrow[2] = (int)Math.round(neckX + orthX);
            arrow[3] = (int)Math.round(neckY + orthY);
            arrow[4] = (int)Math.round(neckX - orthX);
            arrow[5] = (int)Math.round(neckY - orthY);
            return arrow;
        }
        return null;
    }

    private int maxDepth(KNode parent) {
        int maxDepth = 0;
        for (KNode child : parent.getChildren()) {
            int depth = this.maxDepth(child) + 1;
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private static class PaintRectangle {
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean painted = false;

        PaintRectangle(KShapeLayout shapeLayout, KVector offset, double scale) {
            this.x = (int)Math.round((double)shapeLayout.getXpos() * scale + offset.x);
            this.y = (int)Math.round((double)shapeLayout.getYpos() * scale + offset.y);
            this.width = Math.max((int)Math.round((double)shapeLayout.getWidth() * scale), 1);
            this.height = Math.max((int)Math.round((double)shapeLayout.getHeight() * scale), 1);
        }

        PaintRectangle(KEdgeLayout edgeLayout, KVector offset, double scale) {
            float minX = edgeLayout.getSourcePoint().getX();
            float minY = edgeLayout.getSourcePoint().getY();
            float maxX = minX;
            float maxY = minY;
            for (KPoint point : edgeLayout.getBendPoints()) {
                minX = Math.min(minX, point.getX());
                minY = Math.min(minY, point.getY());
                maxX = Math.max(maxX, point.getX());
                maxY = Math.max(maxY, point.getY());
            }
            minX = Math.min(minX, edgeLayout.getTargetPoint().getX());
            minY = Math.min(minY, edgeLayout.getTargetPoint().getY());
            maxX = Math.max(maxX, edgeLayout.getTargetPoint().getX());
            maxY = Math.max(maxY, edgeLayout.getTargetPoint().getY());
            this.x = (int)Math.round((double)minX * scale + offset.x);
            this.y = (int)Math.round((double)minY * scale + offset.y);
            this.width = (int)Math.round((double)(maxX - minX) * scale);
            this.height = (int)Math.round((double)(maxY - minY) * scale);
        }

        public boolean intersects(Rectangle other) {
            return other.x < this.x + this.width && other.y < this.y + this.height && other.x + other.width > this.x && other.y + other.height > this.y;
        }
    }
}

